/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http;

import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBufUtil;
import play.shaded.ahc.io.netty.handler.codec.http.HttpObjectEncoder;
import play.shaded.ahc.io.netty.handler.codec.http.HttpRequest;
import play.shaded.ahc.io.netty.handler.codec.http.HttpResponse;
import play.shaded.ahc.io.netty.util.CharsetUtil;

public class HttpRequestEncoder
extends HttpObjectEncoder<HttpRequest> {
    private static final char SLASH = '/';
    private static final char QUESTION_MARK = '?';
    private static final int SLASH_AND_SPACE_SHORT = 12064;
    private static final int SPACE_SLASH_AND_SPACE_MEDIUM = 0x202F20;

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && !(msg instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpRequest request2) throws Exception {
        ByteBufUtil.copy(request2.method().asciiName(), buf);
        String uri = request2.uri();
        if (uri.isEmpty()) {
            ByteBufUtil.writeMediumBE(buf, 0x202F20);
        } else {
            CharSequence uriCharSequence = uri;
            boolean needSlash = false;
            int start2 = uri.indexOf("://");
            if (start2 != -1 && uri.charAt(0) != '/') {
                int index2 = uri.indexOf(63, start2 += 3);
                if (index2 == -1) {
                    if (uri.lastIndexOf(47) < start2) {
                        needSlash = true;
                    }
                } else if (uri.lastIndexOf(47, index2) < start2) {
                    uriCharSequence = new StringBuilder(uri).insert(index2, '/');
                }
            }
            buf.writeByte(32).writeCharSequence(uriCharSequence, CharsetUtil.UTF_8);
            if (needSlash) {
                ByteBufUtil.writeShortBE(buf, 12064);
            } else {
                buf.writeByte(32);
            }
        }
        request2.protocolVersion().encode(buf);
        ByteBufUtil.writeShortBE(buf, 3338);
    }
}

