/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http;

import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.Unpooled;
import play.shaded.ahc.io.netty.handler.codec.http.CombinedHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpResponse;
import play.shaded.ahc.io.netty.handler.codec.http.FullHttpResponse;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpMessageUtil;
import play.shaded.ahc.io.netty.handler.codec.http.HttpResponseStatus;
import play.shaded.ahc.io.netty.handler.codec.http.HttpVersion;
import play.shaded.ahc.io.netty.util.IllegalReferenceCountException;
import play.shaded.ahc.io.netty.util.internal.ObjectUtil;

public class DefaultFullHttpResponse
extends DefaultHttpResponse
implements FullHttpResponse {
    private final ByteBuf content;
    private final HttpHeaders trailingHeaders;
    private int hash;

    public DefaultFullHttpResponse(HttpVersion version2, HttpResponseStatus status) {
        this(version2, status, Unpooled.buffer(0));
    }

    public DefaultFullHttpResponse(HttpVersion version2, HttpResponseStatus status, ByteBuf content) {
        this(version2, status, content, true);
    }

    public DefaultFullHttpResponse(HttpVersion version2, HttpResponseStatus status, boolean validateHeaders) {
        this(version2, status, Unpooled.buffer(0), validateHeaders, false);
    }

    public DefaultFullHttpResponse(HttpVersion version2, HttpResponseStatus status, boolean validateHeaders, boolean singleFieldHeaders) {
        this(version2, status, Unpooled.buffer(0), validateHeaders, singleFieldHeaders);
    }

    public DefaultFullHttpResponse(HttpVersion version2, HttpResponseStatus status, ByteBuf content, boolean validateHeaders) {
        this(version2, status, content, validateHeaders, false);
    }

    public DefaultFullHttpResponse(HttpVersion version2, HttpResponseStatus status, ByteBuf content, boolean validateHeaders, boolean singleFieldHeaders) {
        super(version2, status, validateHeaders, singleFieldHeaders);
        this.content = ObjectUtil.checkNotNull(content, "content");
        this.trailingHeaders = singleFieldHeaders ? new CombinedHttpHeaders(validateHeaders) : new DefaultHttpHeaders(validateHeaders);
    }

    public DefaultFullHttpResponse(HttpVersion version2, HttpResponseStatus status, ByteBuf content, HttpHeaders headers, HttpHeaders trailingHeaders) {
        super(version2, status, headers);
        this.content = ObjectUtil.checkNotNull(content, "content");
        this.trailingHeaders = ObjectUtil.checkNotNull(trailingHeaders, "trailingHeaders");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullHttpResponse retain() {
        this.content.retain();
        return this;
    }

    @Override
    public FullHttpResponse retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    @Override
    public FullHttpResponse touch() {
        this.content.touch();
        return this;
    }

    @Override
    public FullHttpResponse touch(Object hint) {
        this.content.touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.content.release(decrement);
    }

    @Override
    public FullHttpResponse setProtocolVersion(HttpVersion version2) {
        super.setProtocolVersion(version2);
        return this;
    }

    @Override
    public FullHttpResponse setStatus(HttpResponseStatus status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public FullHttpResponse copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public FullHttpResponse duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public FullHttpResponse retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public FullHttpResponse replace(ByteBuf content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.protocolVersion(), this.status(), content, this.headers().copy(), this.trailingHeaders().copy());
        response.setDecoderResult(this.decoderResult());
        return response;
    }

    @Override
    public int hashCode() {
        int hash2 = this.hash;
        if (hash2 == 0) {
            if (this.content().refCnt() != 0) {
                try {
                    hash2 = 31 + this.content().hashCode();
                }
                catch (IllegalReferenceCountException ignored) {
                    hash2 = 31;
                }
            } else {
                hash2 = 31;
            }
            hash2 = 31 * hash2 + this.trailingHeaders().hashCode();
            this.hash = hash2 = 31 * hash2 + super.hashCode();
        }
        return hash2;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultFullHttpResponse)) {
            return false;
        }
        DefaultFullHttpResponse other = (DefaultFullHttpResponse)o;
        return super.equals(other) && this.content().equals(other.content()) && this.trailingHeaders().equals(other.trailingHeaders());
    }

    @Override
    public String toString() {
        return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
    }
}

