/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import play.shaded.ahc.io.netty.handler.codec.DateFormatter;
import play.shaded.ahc.io.netty.handler.codec.http.Cookie;
import play.shaded.ahc.io.netty.handler.codec.http.CookieUtil;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultCookie;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLogger;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLoggerFactory;

@Deprecated
public final class CookieDecoder {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private static final CookieDecoder STRICT = new CookieDecoder(true);
    private static final CookieDecoder LAX = new CookieDecoder(false);
    private static final String COMMENT = "Comment";
    private static final String COMMENTURL = "CommentURL";
    private static final String DISCARD = "Discard";
    private static final String PORT = "Port";
    private static final String VERSION = "Version";
    private final boolean strict;

    public static Set<Cookie> decode(String header2) {
        return CookieDecoder.decode(header2, true);
    }

    public static Set<Cookie> decode(String header2, boolean strict) {
        return (strict ? STRICT : LAX).doDecode(header2);
    }

    private Set<Cookie> doDecode(String header2) {
        int i;
        ArrayList<String> names = new ArrayList<String>(8);
        ArrayList<String> values2 = new ArrayList<String>(8);
        CookieDecoder.extractKeyValuePairs(header2, names, values2);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        int version2 = 0;
        if (((String)names.get(0)).equalsIgnoreCase(VERSION)) {
            try {
                version2 = Integer.parseInt((String)values2.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            i = 1;
        } else {
            i = 0;
        }
        if (names.size() <= i) {
            return Collections.emptySet();
        }
        TreeSet<Cookie> cookies2 = new TreeSet<Cookie>();
        while (i < names.size()) {
            DefaultCookie c;
            String name = (String)names.get(i);
            String value2 = (String)values2.get(i);
            if (value2 == null) {
                value2 = "";
            }
            if ((c = this.initCookie(name, value2)) == null) break;
            boolean discard = false;
            boolean secure2 = false;
            boolean httpOnly = false;
            String comment2 = null;
            String commentURL = null;
            String domain = null;
            String path2 = null;
            long maxAge2 = Long.MIN_VALUE;
            ArrayList<Integer> ports = new ArrayList<Integer>(2);
            int j = i + 1;
            while (j < names.size()) {
                name = (String)names.get(j);
                value2 = (String)values2.get(j);
                if (DISCARD.equalsIgnoreCase(name)) {
                    discard = true;
                } else if ("Secure".equalsIgnoreCase(name)) {
                    secure2 = true;
                } else if ("HTTPOnly".equalsIgnoreCase(name)) {
                    httpOnly = true;
                } else if (COMMENT.equalsIgnoreCase(name)) {
                    comment2 = value2;
                } else if (COMMENTURL.equalsIgnoreCase(name)) {
                    commentURL = value2;
                } else if ("Domain".equalsIgnoreCase(name)) {
                    domain = value2;
                } else if ("Path".equalsIgnoreCase(name)) {
                    path2 = value2;
                } else if ("Expires".equalsIgnoreCase(name)) {
                    Date date = DateFormatter.parseHttpDate(value2);
                    if (date != null) {
                        long maxAgeMillis = date.getTime() - System.currentTimeMillis();
                        maxAge2 = maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0);
                    }
                } else if ("Max-Age".equalsIgnoreCase(name)) {
                    maxAge2 = Integer.parseInt(value2);
                } else if (VERSION.equalsIgnoreCase(name)) {
                    version2 = Integer.parseInt(value2);
                } else {
                    String[] portList;
                    if (!PORT.equalsIgnoreCase(name)) break;
                    for (String s1 : portList = value2.split(",")) {
                        try {
                            ports.add(Integer.valueOf(s1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                ++j;
                ++i;
            }
            c.setVersion(version2);
            c.setMaxAge(maxAge2);
            c.setPath(path2);
            c.setDomain(domain);
            c.setSecure(secure2);
            c.setHttpOnly(httpOnly);
            if (version2 > 0) {
                c.setComment(comment2);
            }
            if (version2 > 1) {
                c.setCommentUrl(commentURL);
                c.setPorts(ports);
                c.setDiscard(discard);
            }
            cookies2.add(c);
            ++i;
        }
        return cookies2;
    }

    private static void extractKeyValuePairs(String header2, List<String> names, List<String> values2) {
        int headerLen = header2.length();
        int i = 0;
        block10: while (i != headerLen) {
            switch (header2.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ';': {
                    ++i;
                    continue block10;
                }
            }
            while (i != headerLen) {
                String value2;
                String name;
                if (header2.charAt(i) == '$') {
                    ++i;
                    continue;
                }
                if (i == headerLen) {
                    name = null;
                    value2 = null;
                } else {
                    int newNameStart = i;
                    block12: while (true) {
                        switch (header2.charAt(i)) {
                            case ';': {
                                name = header2.substring(newNameStart, i);
                                value2 = null;
                                break block12;
                            }
                            case '=': {
                                name = header2.substring(newNameStart, i);
                                if (++i == headerLen) {
                                    value2 = "";
                                    break block12;
                                }
                                int newValueStart = i;
                                char c = header2.charAt(i);
                                if (c == '\"' || c == '\'') {
                                    StringBuilder newValueBuf = new StringBuilder(header2.length() - i);
                                    char q = c;
                                    boolean hadBackslash = false;
                                    ++i;
                                    block13: while (true) {
                                        if (i == headerLen) {
                                            value2 = newValueBuf.toString();
                                            break block12;
                                        }
                                        if (hadBackslash) {
                                            hadBackslash = false;
                                            c = header2.charAt(i++);
                                            switch (c) {
                                                case '\"': 
                                                case '\'': 
                                                case '\\': {
                                                    newValueBuf.setCharAt(newValueBuf.length() - 1, c);
                                                    continue block13;
                                                }
                                            }
                                            newValueBuf.append(c);
                                            continue;
                                        }
                                        if ((c = header2.charAt(i++)) == q) {
                                            value2 = newValueBuf.toString();
                                            break block12;
                                        }
                                        newValueBuf.append(c);
                                        if (c != '\\') continue;
                                        hadBackslash = true;
                                    }
                                }
                                int semiPos = header2.indexOf(59, i);
                                if (semiPos > 0) {
                                    value2 = header2.substring(newValueStart, semiPos);
                                    i = semiPos;
                                    break block12;
                                }
                                value2 = header2.substring(newValueStart);
                                i = headerLen;
                                break block12;
                            }
                            default: {
                                if (++i != headerLen) continue block12;
                                name = header2.substring(newNameStart);
                                value2 = null;
                                break block12;
                            }
                        }
                        break;
                    }
                }
                names.add(name);
                values2.add(value2);
                continue block10;
            }
            break block10;
        }
    }

    private CookieDecoder(boolean strict) {
        this.strict = strict;
    }

    private DefaultCookie initCookie(String name, String value2) {
        boolean wrap2;
        int invalidOctetPos;
        if (name == null || name.length() == 0) {
            this.logger.debug("Skipping cookie with null name");
            return null;
        }
        if (value2 == null) {
            this.logger.debug("Skipping cookie with null value");
            return null;
        }
        CharSequence unwrappedValue = CookieUtil.unwrapValue(value2);
        if (unwrappedValue == null) {
            this.logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)unwrappedValue);
            return null;
        }
        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieNameOctet(name)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)name, (Object)Character.valueOf(name.charAt(invalidOctetPos)));
            }
            return null;
        }
        boolean bl = wrap2 = unwrappedValue.length() != value2.length();
        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)unwrappedValue, (Object)Character.valueOf(unwrappedValue.charAt(invalidOctetPos)));
            }
            return null;
        }
        DefaultCookie cookie2 = new DefaultCookie(name, unwrappedValue.toString());
        cookie2.setWrap(wrap2);
        return cookie2;
    }
}

