/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.dns;

import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBufUtil;
import play.shaded.ahc.io.netty.channel.socket.InternetProtocolFamily;
import play.shaded.ahc.io.netty.handler.codec.UnsupportedMessageTypeException;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsOptEcsRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsOptPseudoRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsPtrRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsQuestion;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRawRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecordEncoder;
import play.shaded.ahc.io.netty.util.internal.StringUtil;

public class DefaultDnsRecordEncoder
implements DnsRecordEncoder {
    private static final int PREFIX_MASK = 7;

    protected DefaultDnsRecordEncoder() {
    }

    @Override
    public final void encodeQuestion(DnsQuestion question, ByteBuf out) throws Exception {
        this.encodeName(question.name(), out);
        out.writeShort(question.type().intValue());
        out.writeShort(question.dnsClass());
    }

    @Override
    public void encodeRecord(DnsRecord record2, ByteBuf out) throws Exception {
        if (record2 instanceof DnsQuestion) {
            this.encodeQuestion((DnsQuestion)record2, out);
        } else if (record2 instanceof DnsPtrRecord) {
            this.encodePtrRecord((DnsPtrRecord)record2, out);
        } else if (record2 instanceof DnsOptEcsRecord) {
            this.encodeOptEcsRecord((DnsOptEcsRecord)record2, out);
        } else if (record2 instanceof DnsOptPseudoRecord) {
            this.encodeOptPseudoRecord((DnsOptPseudoRecord)record2, out);
        } else if (record2 instanceof DnsRawRecord) {
            this.encodeRawRecord((DnsRawRecord)record2, out);
        } else {
            throw new UnsupportedMessageTypeException(StringUtil.simpleClassName(record2));
        }
    }

    private void encodeRecord0(DnsRecord record2, ByteBuf out) throws Exception {
        this.encodeName(record2.name(), out);
        out.writeShort(record2.type().intValue());
        out.writeShort(record2.dnsClass());
        out.writeInt((int)record2.timeToLive());
    }

    private void encodePtrRecord(DnsPtrRecord record2, ByteBuf out) throws Exception {
        this.encodeRecord0(record2, out);
        this.encodeName(record2.hostname(), out);
    }

    private void encodeOptPseudoRecord(DnsOptPseudoRecord record2, ByteBuf out) throws Exception {
        this.encodeRecord0(record2, out);
        out.writeShort(0);
    }

    private void encodeOptEcsRecord(DnsOptEcsRecord record2, ByteBuf out) throws Exception {
        this.encodeRecord0(record2, out);
        int sourcePrefixLength = record2.sourcePrefixLength();
        int scopePrefixLength = record2.scopePrefixLength();
        int lowOrderBitsToPreserve = sourcePrefixLength & 7;
        byte[] bytes2 = record2.address();
        int addressBits = bytes2.length << 3;
        if (addressBits < sourcePrefixLength || sourcePrefixLength < 0) {
            throw new IllegalArgumentException(sourcePrefixLength + ": " + sourcePrefixLength + " (expected: 0 >= " + addressBits + ')');
        }
        short addressNumber = (short)(bytes2.length == 4 ? InternetProtocolFamily.IPv4.addressNumber() : InternetProtocolFamily.IPv6.addressNumber());
        int payloadLength = DefaultDnsRecordEncoder.calculateEcsAddressLength(sourcePrefixLength, lowOrderBitsToPreserve);
        int fullPayloadLength = 8 + payloadLength;
        out.writeShort(fullPayloadLength);
        out.writeShort(8);
        out.writeShort(fullPayloadLength - 4);
        out.writeShort(addressNumber);
        out.writeByte(sourcePrefixLength);
        out.writeByte(scopePrefixLength);
        if (lowOrderBitsToPreserve > 0) {
            int bytesLength = payloadLength - 1;
            out.writeBytes(bytes2, 0, bytesLength);
            out.writeByte(DefaultDnsRecordEncoder.padWithZeros(bytes2[bytesLength], lowOrderBitsToPreserve));
        } else {
            out.writeBytes(bytes2, 0, payloadLength);
        }
    }

    static int calculateEcsAddressLength(int sourcePrefixLength, int lowOrderBitsToPreserve) {
        return (sourcePrefixLength >>> 3) + (lowOrderBitsToPreserve != 0 ? 1 : 0);
    }

    private void encodeRawRecord(DnsRawRecord record2, ByteBuf out) throws Exception {
        this.encodeRecord0(record2, out);
        ByteBuf content = record2.content();
        int contentLen = content.readableBytes();
        out.writeShort(contentLen);
        out.writeBytes(content, content.readerIndex(), contentLen);
    }

    protected void encodeName(String name, ByteBuf buf) throws Exception {
        String label;
        int labelLen;
        String[] labels;
        if (".".equals(name)) {
            buf.writeByte(0);
            return;
        }
        String[] stringArray = labels = name.split("\\.");
        int n = stringArray.length;
        for (int i = 0; i < n && (labelLen = (label = stringArray[i]).length()) != 0; ++i) {
            buf.writeByte(labelLen);
            ByteBufUtil.writeAscii(buf, (CharSequence)label);
        }
        buf.writeByte(0);
    }

    private static byte padWithZeros(byte b2, int lowOrderBitsToPreserve) {
        switch (lowOrderBitsToPreserve) {
            case 0: {
                return 0;
            }
            case 1: {
                return (byte)(0x80 & b2);
            }
            case 2: {
                return (byte)(0xC0 & b2);
            }
            case 3: {
                return (byte)(0xE0 & b2);
            }
            case 4: {
                return (byte)(0xF0 & b2);
            }
            case 5: {
                return (byte)(0xF8 & b2);
            }
            case 6: {
                return (byte)(0xFC & b2);
            }
            case 7: {
                return (byte)(0xFE & b2);
            }
            case 8: {
                return b2;
            }
        }
        throw new IllegalArgumentException("lowOrderBitsToPreserve: " + lowOrderBitsToPreserve);
    }
}

