/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.dns;

import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.handler.codec.CorruptedFrameException;
import play.shaded.ahc.io.netty.handler.codec.dns.DefaultDnsPtrRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DefaultDnsQuestion;
import play.shaded.ahc.io.netty.handler.codec.dns.DefaultDnsRawRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsQuestion;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecordDecoder;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecordType;
import play.shaded.ahc.io.netty.util.CharsetUtil;

public class DefaultDnsRecordDecoder
implements DnsRecordDecoder {
    static final String ROOT = ".";

    protected DefaultDnsRecordDecoder() {
    }

    @Override
    public final DnsQuestion decodeQuestion(ByteBuf in2) throws Exception {
        String name = DefaultDnsRecordDecoder.decodeName(in2);
        DnsRecordType type = DnsRecordType.valueOf(in2.readUnsignedShort());
        int qClass = in2.readUnsignedShort();
        return new DefaultDnsQuestion(name, type, qClass);
    }

    @Override
    public final <T extends DnsRecord> T decodeRecord(ByteBuf in2) throws Exception {
        int startOffset = in2.readerIndex();
        String name = DefaultDnsRecordDecoder.decodeName(in2);
        int endOffset = in2.writerIndex();
        if (endOffset - startOffset < 10) {
            in2.readerIndex(startOffset);
            return null;
        }
        DnsRecordType type = DnsRecordType.valueOf(in2.readUnsignedShort());
        int aClass = in2.readUnsignedShort();
        long ttl = in2.readUnsignedInt();
        int length2 = in2.readUnsignedShort();
        int offset = in2.readerIndex();
        if (endOffset - offset < length2) {
            in2.readerIndex(startOffset);
            return null;
        }
        DnsRecord record2 = this.decodeRecord(name, type, aClass, ttl, in2, offset, length2);
        in2.readerIndex(offset + length2);
        return (T)record2;
    }

    protected DnsRecord decodeRecord(String name, DnsRecordType type, int dnsClass, long timeToLive, ByteBuf in2, int offset, int length2) throws Exception {
        if (type == DnsRecordType.PTR) {
            return new DefaultDnsPtrRecord(name, dnsClass, timeToLive, this.decodeName0(in2.duplicate().setIndex(offset, offset + length2)));
        }
        return new DefaultDnsRawRecord(name, type, dnsClass, timeToLive, in2.retainedDuplicate().setIndex(offset, offset + length2));
    }

    protected String decodeName0(ByteBuf in2) {
        return DefaultDnsRecordDecoder.decodeName(in2);
    }

    public static String decodeName(ByteBuf in2) {
        int position2 = -1;
        int checked = 0;
        int end = in2.writerIndex();
        int readable = in2.readableBytes();
        if (readable == 0) {
            return ROOT;
        }
        StringBuilder name = new StringBuilder(readable << 1);
        while (in2.isReadable()) {
            boolean pointer;
            short len2 = in2.readUnsignedByte();
            boolean bl = pointer = (len2 & 0xC0) == 192;
            if (pointer) {
                if (position2 == -1) {
                    position2 = in2.readerIndex() + 1;
                }
                if (!in2.isReadable()) {
                    throw new CorruptedFrameException("truncated pointer in a name");
                }
                int next2 = (len2 & 0x3F) << 8 | in2.readUnsignedByte();
                if (next2 >= end) {
                    throw new CorruptedFrameException("name has an out-of-range pointer");
                }
                in2.readerIndex(next2);
                if ((checked += 2) < end) continue;
                throw new CorruptedFrameException("name contains a loop.");
            }
            if (len2 == 0) break;
            if (!in2.isReadable(len2)) {
                throw new CorruptedFrameException("truncated label in a name");
            }
            name.append(in2.toString(in2.readerIndex(), len2, CharsetUtil.UTF_8)).append('.');
            in2.skipBytes(len2);
        }
        if (position2 != -1) {
            in2.readerIndex(position2);
        }
        if (name.length() == 0) {
            return ROOT;
        }
        if (name.charAt(name.length() - 1) != '.') {
            name.append('.');
        }
        return name.toString();
    }
}

