/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.dns;

import java.net.InetSocketAddress;
import java.util.List;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.channel.AddressedEnvelope;
import play.shaded.ahc.io.netty.channel.ChannelHandler;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.channel.socket.DatagramPacket;
import play.shaded.ahc.io.netty.handler.codec.MessageToMessageEncoder;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsQuery;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsQuestion;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecordEncoder;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsSection;
import play.shaded.ahc.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class DatagramDnsQueryEncoder
extends MessageToMessageEncoder<AddressedEnvelope<DnsQuery, InetSocketAddress>> {
    private final DnsRecordEncoder recordEncoder;

    public DatagramDnsQueryEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public DatagramDnsQueryEncoder(DnsRecordEncoder recordEncoder) {
        this.recordEncoder = ObjectUtil.checkNotNull(recordEncoder, "recordEncoder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<DnsQuery, InetSocketAddress> in2, List<Object> out) throws Exception {
        InetSocketAddress recipient = in2.recipient();
        DnsQuery query = in2.content();
        ByteBuf buf = this.allocateBuffer(ctx, in2);
        boolean success2 = false;
        try {
            DatagramDnsQueryEncoder.encodeHeader(query, buf);
            this.encodeQuestions(query, buf);
            this.encodeRecords(query, DnsSection.ADDITIONAL, buf);
            success2 = true;
        }
        finally {
            if (!success2) {
                buf.release();
            }
        }
        out.add(new DatagramPacket(buf, recipient, null));
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, AddressedEnvelope<DnsQuery, InetSocketAddress> msg) throws Exception {
        return ctx.alloc().ioBuffer(1024);
    }

    private static void encodeHeader(DnsQuery query, ByteBuf buf) {
        buf.writeShort(query.id());
        int flags = 0;
        flags |= (query.opCode().byteValue() & 0xFF) << 14;
        if (query.isRecursionDesired()) {
            flags |= 0x100;
        }
        buf.writeShort(flags);
        buf.writeShort(query.count(DnsSection.QUESTION));
        buf.writeShort(0);
        buf.writeShort(0);
        buf.writeShort(query.count(DnsSection.ADDITIONAL));
    }

    private void encodeQuestions(DnsQuery query, ByteBuf buf) throws Exception {
        int count2 = query.count(DnsSection.QUESTION);
        for (int i = 0; i < count2; ++i) {
            this.recordEncoder.encodeQuestion((DnsQuestion)query.recordAt(DnsSection.QUESTION, i), buf);
        }
    }

    private void encodeRecords(DnsQuery query, DnsSection section, ByteBuf buf) throws Exception {
        int count2 = query.count(section);
        for (int i = 0; i < count2; ++i) {
            this.recordEncoder.encodeRecord((DnsRecord)query.recordAt(section, i), buf);
        }
    }
}

