/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.handler.codec.dns;

import java.util.ArrayList;
import java.util.List;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsMessage;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsOpCode;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsQuery;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsQuestion;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsRecord;
import play.shaded.ahc.io.netty.handler.codec.dns.DnsSection;
import play.shaded.ahc.io.netty.util.AbstractReferenceCounted;
import play.shaded.ahc.io.netty.util.ReferenceCountUtil;
import play.shaded.ahc.io.netty.util.ReferenceCounted;
import play.shaded.ahc.io.netty.util.ResourceLeakDetector;
import play.shaded.ahc.io.netty.util.ResourceLeakDetectorFactory;
import play.shaded.ahc.io.netty.util.ResourceLeakTracker;
import play.shaded.ahc.io.netty.util.internal.ObjectUtil;
import play.shaded.ahc.io.netty.util.internal.StringUtil;

public abstract class AbstractDnsMessage
extends AbstractReferenceCounted
implements DnsMessage {
    private static final ResourceLeakDetector<DnsMessage> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(DnsMessage.class);
    private static final int SECTION_QUESTION = DnsSection.QUESTION.ordinal();
    private static final int SECTION_COUNT = 4;
    private final ResourceLeakTracker<DnsMessage> leak = leakDetector.track(this);
    private short id;
    private DnsOpCode opCode;
    private boolean recursionDesired;
    private byte z;
    private Object questions;
    private Object answers;
    private Object authorities;
    private Object additionals;

    protected AbstractDnsMessage(int id2) {
        this(id2, DnsOpCode.QUERY);
    }

    protected AbstractDnsMessage(int id2, DnsOpCode opCode) {
        this.setId(id2);
        this.setOpCode(opCode);
    }

    @Override
    public int id() {
        return this.id & 0xFFFF;
    }

    @Override
    public DnsMessage setId(int id2) {
        this.id = (short)id2;
        return this;
    }

    @Override
    public DnsOpCode opCode() {
        return this.opCode;
    }

    @Override
    public DnsMessage setOpCode(DnsOpCode opCode) {
        this.opCode = ObjectUtil.checkNotNull(opCode, "opCode");
        return this;
    }

    @Override
    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    @Override
    public DnsMessage setRecursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    public DnsMessage setZ(int z2) {
        this.z = (byte)(z2 & 7);
        return this;
    }

    @Override
    public int count(DnsSection section) {
        return this.count(AbstractDnsMessage.sectionOrdinal(section));
    }

    private int count(int section) {
        Object records = this.sectionAt(section);
        if (records == null) {
            return 0;
        }
        if (records instanceof DnsRecord) {
            return 1;
        }
        List recordList = (List)records;
        return recordList.size();
    }

    @Override
    public int count() {
        int count2 = 0;
        for (int i = 0; i < 4; ++i) {
            count2 += this.count(i);
        }
        return count2;
    }

    @Override
    public <T extends DnsRecord> T recordAt(DnsSection section) {
        return this.recordAt(AbstractDnsMessage.sectionOrdinal(section));
    }

    private <T extends DnsRecord> T recordAt(int section) {
        Object records = this.sectionAt(section);
        if (records == null) {
            return null;
        }
        if (records instanceof DnsRecord) {
            return AbstractDnsMessage.castRecord(records);
        }
        List recordList = (List)records;
        if (recordList.isEmpty()) {
            return null;
        }
        return AbstractDnsMessage.castRecord(recordList.get(0));
    }

    @Override
    public <T extends DnsRecord> T recordAt(DnsSection section, int index2) {
        return this.recordAt(AbstractDnsMessage.sectionOrdinal(section), index2);
    }

    private <T extends DnsRecord> T recordAt(int section, int index2) {
        Object records = this.sectionAt(section);
        if (records == null) {
            throw new IndexOutOfBoundsException("index: " + index2 + " (expected: none)");
        }
        if (records instanceof DnsRecord) {
            if (index2 == 0) {
                return AbstractDnsMessage.castRecord(records);
            }
            throw new IndexOutOfBoundsException("index: " + index2 + "' (expected: 0)");
        }
        List recordList = (List)records;
        return AbstractDnsMessage.castRecord(recordList.get(index2));
    }

    @Override
    public DnsMessage setRecord(DnsSection section, DnsRecord record2) {
        this.setRecord(AbstractDnsMessage.sectionOrdinal(section), record2);
        return this;
    }

    private void setRecord(int section, DnsRecord record2) {
        this.clear(section);
        this.setSection(section, AbstractDnsMessage.checkQuestion(section, record2));
    }

    @Override
    public <T extends DnsRecord> T setRecord(DnsSection section, int index2, DnsRecord record2) {
        return this.setRecord(AbstractDnsMessage.sectionOrdinal(section), index2, record2);
    }

    private <T extends DnsRecord> T setRecord(int section, int index2, DnsRecord record2) {
        AbstractDnsMessage.checkQuestion(section, record2);
        Object records = this.sectionAt(section);
        if (records == null) {
            throw new IndexOutOfBoundsException("index: " + index2 + " (expected: none)");
        }
        if (records instanceof DnsRecord) {
            if (index2 == 0) {
                this.setSection(section, record2);
                return AbstractDnsMessage.castRecord(records);
            }
            throw new IndexOutOfBoundsException("index: " + index2 + " (expected: 0)");
        }
        List recordList = (List)records;
        return AbstractDnsMessage.castRecord(recordList.set(index2, record2));
    }

    @Override
    public DnsMessage addRecord(DnsSection section, DnsRecord record2) {
        this.addRecord(AbstractDnsMessage.sectionOrdinal(section), record2);
        return this;
    }

    private void addRecord(int section, DnsRecord record2) {
        AbstractDnsMessage.checkQuestion(section, record2);
        Object records = this.sectionAt(section);
        if (records == null) {
            this.setSection(section, record2);
            return;
        }
        if (records instanceof DnsRecord) {
            ArrayList<DnsRecord> recordList = AbstractDnsMessage.newRecordList();
            recordList.add((DnsRecord)AbstractDnsMessage.castRecord(records));
            recordList.add(record2);
            this.setSection(section, recordList);
            return;
        }
        List recordList = (List)records;
        recordList.add(record2);
    }

    @Override
    public DnsMessage addRecord(DnsSection section, int index2, DnsRecord record2) {
        this.addRecord(AbstractDnsMessage.sectionOrdinal(section), index2, record2);
        return this;
    }

    private void addRecord(int section, int index2, DnsRecord record2) {
        AbstractDnsMessage.checkQuestion(section, record2);
        Object records = this.sectionAt(section);
        if (records == null) {
            if (index2 != 0) {
                throw new IndexOutOfBoundsException("index: " + index2 + " (expected: 0)");
            }
            this.setSection(section, record2);
            return;
        }
        if (records instanceof DnsRecord) {
            ArrayList<DnsRecord> recordList;
            if (index2 == 0) {
                recordList = AbstractDnsMessage.newRecordList();
                recordList.add(record2);
                recordList.add((DnsRecord)AbstractDnsMessage.castRecord(records));
            } else if (index2 == 1) {
                recordList = AbstractDnsMessage.newRecordList();
                recordList.add((DnsRecord)AbstractDnsMessage.castRecord(records));
                recordList.add(record2);
            } else {
                throw new IndexOutOfBoundsException("index: " + index2 + " (expected: 0 or 1)");
            }
            this.setSection(section, recordList);
            return;
        }
        List recordList = (List)records;
        recordList.add(index2, record2);
    }

    @Override
    public <T extends DnsRecord> T removeRecord(DnsSection section, int index2) {
        return this.removeRecord(AbstractDnsMessage.sectionOrdinal(section), index2);
    }

    private <T extends DnsRecord> T removeRecord(int section, int index2) {
        Object records = this.sectionAt(section);
        if (records == null) {
            throw new IndexOutOfBoundsException("index: " + index2 + " (expected: none)");
        }
        if (records instanceof DnsRecord) {
            if (index2 != 0) {
                throw new IndexOutOfBoundsException("index: " + index2 + " (expected: 0)");
            }
            T record2 = AbstractDnsMessage.castRecord(records);
            this.setSection(section, null);
            return record2;
        }
        List recordList = (List)records;
        return AbstractDnsMessage.castRecord(recordList.remove(index2));
    }

    @Override
    public DnsMessage clear(DnsSection section) {
        this.clear(AbstractDnsMessage.sectionOrdinal(section));
        return this;
    }

    @Override
    public DnsMessage clear() {
        for (int i = 0; i < 4; ++i) {
            this.clear(i);
        }
        return this;
    }

    private void clear(int section) {
        List list2;
        Object recordOrList = this.sectionAt(section);
        this.setSection(section, null);
        if (recordOrList instanceof ReferenceCounted) {
            ((ReferenceCounted)recordOrList).release();
        } else if (recordOrList instanceof List && !(list2 = (List)recordOrList).isEmpty()) {
            for (Object r : list2) {
                ReferenceCountUtil.release(r);
            }
        }
    }

    @Override
    public DnsMessage touch() {
        return (DnsMessage)super.touch();
    }

    @Override
    public DnsMessage touch(Object hint) {
        if (this.leak != null) {
            this.leak.record(hint);
        }
        return this;
    }

    @Override
    public DnsMessage retain() {
        return (DnsMessage)super.retain();
    }

    @Override
    public DnsMessage retain(int increment) {
        return (DnsMessage)super.retain(increment);
    }

    @Override
    protected void deallocate() {
        this.clear();
        ResourceLeakTracker<DnsMessage> leak = this.leak;
        if (leak != null) {
            boolean closed = leak.close(this);
            assert (closed);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DnsMessage)) {
            return false;
        }
        DnsMessage that2 = (DnsMessage)obj;
        if (this.id() != that2.id()) {
            return false;
        }
        return !(this instanceof DnsQuery ? !(that2 instanceof DnsQuery) : that2 instanceof DnsQuery);
    }

    public int hashCode() {
        return this.id() * 31 + (this instanceof DnsQuery ? 0 : 1);
    }

    private Object sectionAt(int section) {
        switch (section) {
            case 0: {
                return this.questions;
            }
            case 1: {
                return this.answers;
            }
            case 2: {
                return this.authorities;
            }
            case 3: {
                return this.additionals;
            }
        }
        throw new Error();
    }

    private void setSection(int section, Object value2) {
        switch (section) {
            case 0: {
                this.questions = value2;
                return;
            }
            case 1: {
                this.answers = value2;
                return;
            }
            case 2: {
                this.authorities = value2;
                return;
            }
            case 3: {
                this.additionals = value2;
                return;
            }
        }
        throw new Error();
    }

    private static int sectionOrdinal(DnsSection section) {
        return ObjectUtil.checkNotNull(section, "section").ordinal();
    }

    private static DnsRecord checkQuestion(int section, DnsRecord record2) {
        if (section == SECTION_QUESTION && !(ObjectUtil.checkNotNull(record2, "record") instanceof DnsQuestion)) {
            throw new IllegalArgumentException("record: " + record2 + " (expected: " + StringUtil.simpleClassName(DnsQuestion.class) + ')');
        }
        return record2;
    }

    private static <T extends DnsRecord> T castRecord(Object record2) {
        return (T)((DnsRecord)record2);
    }

    private static ArrayList<DnsRecord> newRecordList() {
        return new ArrayList<DnsRecord>(2);
    }
}

