/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.channel.unix;

import java.nio.ByteBuffer;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.channel.ChannelOutboundBuffer;
import play.shaded.ahc.io.netty.channel.unix.Buffer;
import play.shaded.ahc.io.netty.channel.unix.Limits;
import play.shaded.ahc.io.netty.util.internal.ObjectUtil;
import play.shaded.ahc.io.netty.util.internal.PlatformDependent;

public final class IovArray
implements ChannelOutboundBuffer.MessageProcessor {
    private static final int ADDRESS_SIZE = Buffer.addressSize();
    private static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int CAPACITY = Limits.IOV_MAX * IOV_SIZE;
    private final ByteBuffer memory;
    private final long memoryAddress;
    private int count;
    private long size;
    private long maxBytes = Limits.SSIZE_MAX;

    public IovArray() {
        this.memory = Buffer.allocateDirectWithNativeOrder(CAPACITY);
        this.memoryAddress = Buffer.memoryAddress(this.memory);
    }

    public void clear() {
        this.count = 0;
        this.size = 0L;
    }

    public boolean add(ByteBuf buf) {
        ByteBuffer[] buffers;
        if (this.count == Limits.IOV_MAX) {
            return false;
        }
        if (buf.nioBufferCount() == 1) {
            int len2 = buf.readableBytes();
            if (len2 == 0) {
                return true;
            }
            if (buf.hasMemoryAddress()) {
                return this.add(buf.memoryAddress(), buf.readerIndex(), len2);
            }
            ByteBuffer nioBuffer = buf.internalNioBuffer(buf.readerIndex(), len2);
            return this.add(Buffer.memoryAddress(nioBuffer), nioBuffer.position(), len2);
        }
        for (ByteBuffer nioBuffer : buffers = buf.nioBuffers()) {
            int len3 = nioBuffer.remaining();
            if (len3 == 0 || this.add(Buffer.memoryAddress(nioBuffer), nioBuffer.position(), len3) && this.count != Limits.IOV_MAX) continue;
            return false;
        }
        return true;
    }

    private boolean add(long addr, int offset, int len2) {
        assert (addr != 0L);
        if (this.maxBytes - (long)len2 < this.size && this.count > 0) {
            return false;
        }
        int baseOffset = IovArray.idx(this.count);
        int lengthOffset = baseOffset + ADDRESS_SIZE;
        this.size += (long)len2;
        ++this.count;
        if (ADDRESS_SIZE == 8) {
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putLong((long)baseOffset + this.memoryAddress, addr + (long)offset);
                PlatformDependent.putLong((long)lengthOffset + this.memoryAddress, len2);
            } else {
                this.memory.putLong(baseOffset, addr + (long)offset);
                this.memory.putLong(lengthOffset, len2);
            }
        } else {
            assert (ADDRESS_SIZE == 4);
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putInt((long)baseOffset + this.memoryAddress, (int)addr + offset);
                PlatformDependent.putInt((long)lengthOffset + this.memoryAddress, len2);
            } else {
                this.memory.putInt(baseOffset, (int)addr + offset);
                this.memory.putInt(lengthOffset, len2);
            }
        }
        return true;
    }

    public int count() {
        return this.count;
    }

    public long size() {
        return this.size;
    }

    public void maxBytes(long maxBytes) {
        this.maxBytes = Math.min(Limits.SSIZE_MAX, ObjectUtil.checkPositive(maxBytes, "maxBytes"));
    }

    public long maxBytes() {
        return this.maxBytes;
    }

    public long memoryAddress(int offset) {
        return this.memoryAddress + (long)IovArray.idx(offset);
    }

    public void release() {
        Buffer.free(this.memory);
    }

    @Override
    public boolean processMessage(Object msg) throws Exception {
        return msg instanceof ByteBuf && this.add((ByteBuf)msg);
    }

    private static int idx(int index2) {
        return IOV_SIZE * index2;
    }
}

