/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.channel.epoll;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelException;
import play.shaded.ahc.io.netty.channel.epoll.AbstractEpollChannel;
import play.shaded.ahc.io.netty.channel.epoll.AbstractEpollStreamChannel;
import play.shaded.ahc.io.netty.channel.epoll.EpollEventLoop;
import play.shaded.ahc.io.netty.channel.epoll.EpollServerSocketChannel;
import play.shaded.ahc.io.netty.channel.epoll.EpollSocketChannelConfig;
import play.shaded.ahc.io.netty.channel.epoll.EpollTcpInfo;
import play.shaded.ahc.io.netty.channel.epoll.LinuxSocket;
import play.shaded.ahc.io.netty.channel.epoll.TcpMd5Util;
import play.shaded.ahc.io.netty.channel.socket.ServerSocketChannel;
import play.shaded.ahc.io.netty.channel.socket.SocketChannel;
import play.shaded.ahc.io.netty.util.concurrent.GlobalEventExecutor;

public final class EpollSocketChannel
extends AbstractEpollStreamChannel
implements SocketChannel {
    private final EpollSocketChannelConfig config;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    public EpollSocketChannel() {
        super(LinuxSocket.newSocketStream(), false);
        this.config = new EpollSocketChannelConfig(this);
    }

    public EpollSocketChannel(int fd) {
        super(fd);
        this.config = new EpollSocketChannelConfig(this);
    }

    EpollSocketChannel(LinuxSocket fd, boolean active) {
        super(fd, active);
        this.config = new EpollSocketChannelConfig(this);
    }

    EpollSocketChannel(Channel parent2, LinuxSocket fd, InetSocketAddress remoteAddress) {
        super(parent2, fd, remoteAddress);
        this.config = new EpollSocketChannelConfig(this);
        if (parent2 instanceof EpollServerSocketChannel) {
            this.tcpMd5SigAddresses = ((EpollServerSocketChannel)parent2).tcpMd5SigAddresses();
        }
    }

    public EpollTcpInfo tcpInfo() {
        return this.tcpInfo(new EpollTcpInfo());
    }

    public EpollTcpInfo tcpInfo(EpollTcpInfo info2) {
        try {
            this.socket.getTcpInfo(info2);
            return info2;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public EpollSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollSocketChannelUnsafe();
    }

    void setTcpMd5Sig(Map<InetAddress, byte[]> keys2) throws IOException {
        this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, keys2);
    }

    private final class EpollSocketChannelUnsafe
    extends AbstractEpollStreamChannel.EpollStreamUnsafe {
        private EpollSocketChannelUnsafe() {
        }

        @Override
        protected Executor prepareToClose() {
            try {
                if (EpollSocketChannel.this.isOpen() && EpollSocketChannel.this.config().getSoLinger() > 0) {
                    ((EpollEventLoop)EpollSocketChannel.this.eventLoop()).remove(EpollSocketChannel.this);
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return null;
        }
    }
}

