/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.channel.embedded;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelFuture;
import play.shaded.ahc.io.netty.channel.ChannelPromise;
import play.shaded.ahc.io.netty.channel.DefaultChannelPromise;
import play.shaded.ahc.io.netty.channel.EventLoop;
import play.shaded.ahc.io.netty.channel.EventLoopGroup;
import play.shaded.ahc.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import play.shaded.ahc.io.netty.util.concurrent.Future;
import play.shaded.ahc.io.netty.util.internal.ObjectUtil;

final class EmbeddedEventLoop
extends AbstractScheduledEventExecutor
implements EventLoop {
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(2);

    EmbeddedEventLoop() {
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        this.tasks.add(command);
    }

    void runTasks() {
        Runnable task2;
        while ((task2 = this.tasks.poll()) != null) {
            task2.run();
        }
    }

    long runScheduledTasks() {
        long time = AbstractScheduledEventExecutor.nanoTime();
        Runnable task2;
        while ((task2 = this.pollScheduledTask(time)) != null) {
            task2.run();
        }
        return this.nextScheduledTaskNano();
    }

    long nextScheduledTask() {
        return this.nextScheduledTaskNano();
    }

    @Override
    protected void cancelScheduledTasks() {
        super.cancelScheduledTasks();
    }

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> terminationFuture() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShuttingDown() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit2) {
        return false;
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.register(new DefaultChannelPromise(channel, this));
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        promise.channel().unsafe().register(this, promise);
        return promise;
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        channel.unsafe().register(this, promise);
        return promise;
    }

    @Override
    public boolean inEventLoop() {
        return true;
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return true;
    }
}

