/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.channel;

import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelFuture;
import play.shaded.ahc.io.netty.channel.ChannelFutureListener;
import play.shaded.ahc.io.netty.channel.ChannelPromise;
import play.shaded.ahc.io.netty.channel.EventLoopGroup;
import play.shaded.ahc.io.netty.channel.SingleThreadEventLoop;
import play.shaded.ahc.io.netty.channel.ThreadPerChannelEventLoopGroup;

public class ThreadPerChannelEventLoop
extends SingleThreadEventLoop {
    private final ThreadPerChannelEventLoopGroup parent;
    private Channel ch;

    public ThreadPerChannelEventLoop(ThreadPerChannelEventLoopGroup parent2) {
        super((EventLoopGroup)parent2, parent2.executor, true);
        this.parent = parent2;
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        return super.register(promise).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future2) throws Exception {
                if (future2.isSuccess()) {
                    ThreadPerChannelEventLoop.this.ch = future2.channel();
                } else {
                    ThreadPerChannelEventLoop.this.deregister();
                }
            }
        });
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return super.register(channel, promise).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future2) throws Exception {
                if (future2.isSuccess()) {
                    ThreadPerChannelEventLoop.this.ch = future2.channel();
                } else {
                    ThreadPerChannelEventLoop.this.deregister();
                }
            }
        });
    }

    @Override
    protected void run() {
        while (true) {
            Runnable task2;
            if ((task2 = this.takeTask()) != null) {
                task2.run();
                this.updateLastExecutionTime();
            }
            Channel ch = this.ch;
            if (this.isShuttingDown()) {
                if (ch != null) {
                    ch.unsafe().close(ch.unsafe().voidPromise());
                }
                if (!this.confirmShutdown()) continue;
                break;
            }
            if (ch == null || ch.isRegistered()) continue;
            this.runAllTasks();
            this.deregister();
        }
    }

    protected void deregister() {
        this.ch = null;
        this.parent.activeChildren.remove(this);
        this.parent.idleChildren.add(this);
    }
}

