/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.channel;

import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelFuture;
import play.shaded.ahc.io.netty.channel.ChannelPromise;
import play.shaded.ahc.io.netty.channel.DefaultChannelPromise;
import play.shaded.ahc.io.netty.channel.EventLoop;
import play.shaded.ahc.io.netty.channel.EventLoopGroup;
import play.shaded.ahc.io.netty.util.concurrent.EventExecutorGroup;
import play.shaded.ahc.io.netty.util.concurrent.RejectedExecutionHandler;
import play.shaded.ahc.io.netty.util.concurrent.RejectedExecutionHandlers;
import play.shaded.ahc.io.netty.util.concurrent.SingleThreadEventExecutor;
import play.shaded.ahc.io.netty.util.internal.ObjectUtil;
import play.shaded.ahc.io.netty.util.internal.SystemPropertyUtil;

public abstract class SingleThreadEventLoop
extends SingleThreadEventExecutor
implements EventLoop {
    protected static final int DEFAULT_MAX_PENDING_TASKS = Math.max(16, SystemPropertyUtil.getInt("play.shaded.ahc.io.netty.eventLoop.maxPendingTasks", Integer.MAX_VALUE));
    private final Queue<Runnable> tailTasks;

    protected SingleThreadEventLoop(EventLoopGroup parent2, ThreadFactory threadFactory, boolean addTaskWakesUp) {
        this(parent2, threadFactory, addTaskWakesUp, DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
    }

    protected SingleThreadEventLoop(EventLoopGroup parent2, Executor executor, boolean addTaskWakesUp) {
        this(parent2, executor, addTaskWakesUp, DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
    }

    protected SingleThreadEventLoop(EventLoopGroup parent2, ThreadFactory threadFactory, boolean addTaskWakesUp, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventExecutorGroup)parent2, threadFactory, addTaskWakesUp, maxPendingTasks, rejectedExecutionHandler);
        this.tailTasks = this.newTaskQueue(maxPendingTasks);
    }

    protected SingleThreadEventLoop(EventLoopGroup parent2, Executor executor, boolean addTaskWakesUp, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventExecutorGroup)parent2, executor, addTaskWakesUp, maxPendingTasks, rejectedExecutionHandler);
        this.tailTasks = this.newTaskQueue(maxPendingTasks);
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.register(new DefaultChannelPromise(channel, this));
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        promise.channel().unsafe().register(this, promise);
        return promise;
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        channel.unsafe().register(this, promise);
        return promise;
    }

    public final void executeAfterEventLoopIteration(Runnable task2) {
        ObjectUtil.checkNotNull(task2, "task");
        if (this.isShutdown()) {
            SingleThreadEventLoop.reject();
        }
        if (!this.tailTasks.offer(task2)) {
            this.reject(task2);
        }
        if (this.wakesUpForTask(task2)) {
            this.wakeup(this.inEventLoop());
        }
    }

    final boolean removeAfterEventLoopIterationTask(Runnable task2) {
        return this.tailTasks.remove(ObjectUtil.checkNotNull(task2, "task"));
    }

    @Override
    protected boolean wakesUpForTask(Runnable task2) {
        return !(task2 instanceof NonWakeupRunnable);
    }

    @Override
    protected void afterRunningAllTasks() {
        this.runAllTasksFrom(this.tailTasks);
    }

    @Override
    protected boolean hasTasks() {
        return super.hasTasks() || !this.tailTasks.isEmpty();
    }

    @Override
    public int pendingTasks() {
        return super.pendingTasks() + this.tailTasks.size();
    }

    static interface NonWakeupRunnable
    extends Runnable {
    }
}

