/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import play.shaded.ahc.io.netty.buffer.AbstractReferenceCountedByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBufAllocator;
import play.shaded.ahc.io.netty.buffer.HeapByteBufUtil;
import play.shaded.ahc.io.netty.util.internal.EmptyArrays;
import play.shaded.ahc.io.netty.util.internal.ObjectUtil;
import play.shaded.ahc.io.netty.util.internal.PlatformDependent;

public class UnpooledHeapByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    byte[] array;
    private ByteBuffer tmpNioBuf;

    public UnpooledHeapByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super(maxCapacity);
        ObjectUtil.checkNotNull(alloc, "alloc");
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialCapacity, maxCapacity));
        }
        this.alloc = alloc;
        this.setArray(this.allocateArray(initialCapacity));
        this.setIndex(0, 0);
    }

    protected UnpooledHeapByteBuf(ByteBufAllocator alloc, byte[] initialArray, int maxCapacity) {
        super(maxCapacity);
        ObjectUtil.checkNotNull(alloc, "alloc");
        ObjectUtil.checkNotNull(initialArray, "initialArray");
        if (initialArray.length > maxCapacity) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialArray.length, maxCapacity));
        }
        this.alloc = alloc;
        this.setArray(initialArray);
        this.setIndex(0, initialArray.length);
    }

    protected byte[] allocateArray(int initialCapacity) {
        return new byte[initialCapacity];
    }

    protected void freeArray(byte[] array2) {
    }

    private void setArray(byte[] initialArray) {
        this.array = initialArray;
        this.tmpNioBuf = null;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        this.checkNewCapacity(newCapacity);
        int oldCapacity = this.array.length;
        byte[] oldArray = this.array;
        if (newCapacity > oldCapacity) {
            byte[] newArray = this.allocateArray(newCapacity);
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            this.setArray(newArray);
            this.freeArray(oldArray);
        } else if (newCapacity < oldCapacity) {
            byte[] newArray = this.allocateArray(newCapacity);
            int readerIndex = this.readerIndex();
            if (readerIndex < newCapacity) {
                int writerIndex = this.writerIndex();
                if (writerIndex > newCapacity) {
                    writerIndex = newCapacity;
                    this.writerIndex(writerIndex);
                }
                System.arraycopy(oldArray, readerIndex, newArray, readerIndex, writerIndex - readerIndex);
            } else {
                this.setIndex(newCapacity, newCapacity);
            }
            this.setArray(newArray);
            this.freeArray(oldArray);
        }
        return this;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        this.ensureAccessible();
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        this.checkDstIndex(index2, length2, dstIndex, dst.capacity());
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory(this.array, index2, dst.memoryAddress() + (long)dstIndex, (long)length2);
        } else if (dst.hasArray()) {
            this.getBytes(index2, dst.array(), dst.arrayOffset() + dstIndex, length2);
        } else {
            dst.setBytes(dstIndex, this.array, index2, length2);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.checkDstIndex(index2, length2, dstIndex, dst.length);
        System.arraycopy(this.array, index2, dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.checkIndex(index2, dst.remaining());
        dst.put(this.array, index2, dst.remaining());
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length2) throws IOException {
        this.ensureAccessible();
        out.write(this.array, index2, length2);
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        this.ensureAccessible();
        return this.getBytes(index2, out, length2, false);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position2, int length2) throws IOException {
        this.ensureAccessible();
        return this.getBytes(index2, out, position2, length2, false);
    }

    private int getBytes(int index2, GatheringByteChannel out, int length2, boolean internal) throws IOException {
        this.ensureAccessible();
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return out.write((ByteBuffer)tmpBuf.clear().position(index2).limit(index2 + length2));
    }

    private int getBytes(int index2, FileChannel out, long position2, int length2, boolean internal) throws IOException {
        this.ensureAccessible();
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return out.write((ByteBuffer)tmpBuf.clear().position(index2).limit(index2 + length2), position2);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes2 = this.getBytes(this.readerIndex, out, length2, true);
        this.readerIndex += readBytes2;
        return readBytes2;
    }

    @Override
    public int readBytes(FileChannel out, long position2, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes2 = this.getBytes(this.readerIndex, out, position2, length2, true);
        this.readerIndex += readBytes2;
        return readBytes2;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.capacity());
        if (src.hasMemoryAddress()) {
            PlatformDependent.copyMemory(src.memoryAddress() + (long)srcIndex, this.array, index2, (long)length2);
        } else if (src.hasArray()) {
            this.setBytes(index2, src.array(), src.arrayOffset() + srcIndex, length2);
        } else {
            src.getBytes(srcIndex, this.array, index2, length2);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.length);
        System.arraycopy(src, srcIndex, this.array, index2, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.ensureAccessible();
        src.get(this.array, index2, src.remaining());
        return this;
    }

    @Override
    public int setBytes(int index2, InputStream in2, int length2) throws IOException {
        this.ensureAccessible();
        return in2.read(this.array, index2, length2);
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in2, int length2) throws IOException {
        this.ensureAccessible();
        try {
            return in2.read((ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length2));
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public int setBytes(int index2, FileChannel in2, long position2, int length2) throws IOException {
        this.ensureAccessible();
        try {
            return in2.read((ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length2), position2);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length2) {
        this.ensureAccessible();
        return ByteBuffer.wrap(this.array, index2, length2).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length2) {
        return new ByteBuffer[]{this.nioBuffer(index2, length2)};
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length2);
    }

    @Override
    public byte getByte(int index2) {
        this.ensureAccessible();
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return HeapByteBufUtil.getByte(this.array, index2);
    }

    @Override
    public short getShort(int index2) {
        this.ensureAccessible();
        return this._getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return HeapByteBufUtil.getShort(this.array, index2);
    }

    @Override
    public short getShortLE(int index2) {
        this.ensureAccessible();
        return this._getShortLE(index2);
    }

    @Override
    protected short _getShortLE(int index2) {
        return HeapByteBufUtil.getShortLE(this.array, index2);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return HeapByteBufUtil.getUnsignedMedium(this.array, index2);
    }

    @Override
    public int getUnsignedMediumLE(int index2) {
        this.ensureAccessible();
        return this._getUnsignedMediumLE(index2);
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return HeapByteBufUtil.getUnsignedMediumLE(this.array, index2);
    }

    @Override
    public int getInt(int index2) {
        this.ensureAccessible();
        return this._getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return HeapByteBufUtil.getInt(this.array, index2);
    }

    @Override
    public int getIntLE(int index2) {
        this.ensureAccessible();
        return this._getIntLE(index2);
    }

    @Override
    protected int _getIntLE(int index2) {
        return HeapByteBufUtil.getIntLE(this.array, index2);
    }

    @Override
    public long getLong(int index2) {
        this.ensureAccessible();
        return this._getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return HeapByteBufUtil.getLong(this.array, index2);
    }

    @Override
    public long getLongLE(int index2) {
        this.ensureAccessible();
        return this._getLongLE(index2);
    }

    @Override
    protected long _getLongLE(int index2) {
        return HeapByteBufUtil.getLongLE(this.array, index2);
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        this.ensureAccessible();
        this._setByte(index2, value2);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        HeapByteBufUtil.setByte(this.array, index2, value2);
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        this.ensureAccessible();
        this._setShort(index2, value2);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value2) {
        HeapByteBufUtil.setShort(this.array, index2, value2);
    }

    @Override
    public ByteBuf setShortLE(int index2, int value2) {
        this.ensureAccessible();
        this._setShortLE(index2, value2);
        return this;
    }

    @Override
    protected void _setShortLE(int index2, int value2) {
        HeapByteBufUtil.setShortLE(this.array, index2, value2);
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        this.ensureAccessible();
        this._setMedium(index2, value2);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        HeapByteBufUtil.setMedium(this.array, index2, value2);
    }

    @Override
    public ByteBuf setMediumLE(int index2, int value2) {
        this.ensureAccessible();
        this._setMediumLE(index2, value2);
        return this;
    }

    @Override
    protected void _setMediumLE(int index2, int value2) {
        HeapByteBufUtil.setMediumLE(this.array, index2, value2);
    }

    @Override
    public ByteBuf setInt(int index2, int value2) {
        this.ensureAccessible();
        this._setInt(index2, value2);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value2) {
        HeapByteBufUtil.setInt(this.array, index2, value2);
    }

    @Override
    public ByteBuf setIntLE(int index2, int value2) {
        this.ensureAccessible();
        this._setIntLE(index2, value2);
        return this;
    }

    @Override
    protected void _setIntLE(int index2, int value2) {
        HeapByteBufUtil.setIntLE(this.array, index2, value2);
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        this.ensureAccessible();
        this._setLong(index2, value2);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value2) {
        HeapByteBufUtil.setLong(this.array, index2, value2);
    }

    @Override
    public ByteBuf setLongLE(int index2, long value2) {
        this.ensureAccessible();
        this._setLongLE(index2, value2);
        return this;
    }

    @Override
    protected void _setLongLE(int index2, long value2) {
        HeapByteBufUtil.setLongLE(this.array, index2, value2);
    }

    @Override
    public ByteBuf copy(int index2, int length2) {
        this.checkIndex(index2, length2);
        byte[] copiedArray = new byte[length2];
        System.arraycopy(this.array, index2, copiedArray, 0, length2);
        return new UnpooledHeapByteBuf(this.alloc(), copiedArray, this.maxCapacity());
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = ByteBuffer.wrap(this.array);
        }
        return tmpNioBuf;
    }

    @Override
    protected void deallocate() {
        this.freeArray(this.array);
        this.array = EmptyArrays.EMPTY_BYTES;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }
}

