/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.HeapByteBufUtil;
import play.shaded.ahc.io.netty.buffer.PooledByteBuf;
import play.shaded.ahc.io.netty.util.Recycler;
import play.shaded.ahc.io.netty.util.internal.PlatformDependent;

class PooledHeapByteBuf
extends PooledByteBuf<byte[]> {
    private static final Recycler<PooledHeapByteBuf> RECYCLER = new Recycler<PooledHeapByteBuf>(){

        @Override
        protected PooledHeapByteBuf newObject(Recycler.Handle<PooledHeapByteBuf> handle) {
            return new PooledHeapByteBuf((Recycler.Handle<? extends PooledHeapByteBuf>)handle, 0);
        }
    };

    static PooledHeapByteBuf newInstance(int maxCapacity) {
        PooledHeapByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    PooledHeapByteBuf(Recycler.Handle<? extends PooledHeapByteBuf> recyclerHandle, int maxCapacity) {
        super(recyclerHandle, maxCapacity);
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    protected byte _getByte(int index2) {
        return HeapByteBufUtil.getByte((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return HeapByteBufUtil.getShort((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected short _getShortLE(int index2) {
        return HeapByteBufUtil.getShortLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return HeapByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return HeapByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getInt(int index2) {
        return HeapByteBufUtil.getInt((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getIntLE(int index2) {
        return HeapByteBufUtil.getIntLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return HeapByteBufUtil.getLong((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected long _getLongLE(int index2) {
        return HeapByteBufUtil.getLongLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    public final ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        this.checkDstIndex(index2, length2, dstIndex, dst.capacity());
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory((byte[])this.memory, this.idx(index2), dst.memoryAddress() + (long)dstIndex, (long)length2);
        } else if (dst.hasArray()) {
            this.getBytes(index2, dst.array(), dst.arrayOffset() + dstIndex, length2);
        } else {
            dst.setBytes(dstIndex, (byte[])this.memory, this.idx(index2), length2);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.checkDstIndex(index2, length2, dstIndex, dst.length);
        System.arraycopy(this.memory, this.idx(index2), dst, dstIndex, length2);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.checkIndex(index2, dst.remaining());
        dst.put((byte[])this.memory, this.idx(index2), dst.remaining());
        return this;
    }

    @Override
    public final ByteBuf getBytes(int index2, OutputStream out, int length2) throws IOException {
        this.checkIndex(index2, length2);
        out.write((byte[])this.memory, this.idx(index2), length2);
        return this;
    }

    @Override
    public final int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        return this.getBytes(index2, out, length2, false);
    }

    private int getBytes(int index2, GatheringByteChannel out, int length2, boolean internal) throws IOException {
        this.checkIndex(index2, length2);
        index2 = this.idx(index2);
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ByteBuffer.wrap((byte[])this.memory);
        return out.write((ByteBuffer)tmpBuf.clear().position(index2).limit(index2 + length2));
    }

    @Override
    public final int getBytes(int index2, FileChannel out, long position2, int length2) throws IOException {
        return this.getBytes(index2, out, position2, length2, false);
    }

    private int getBytes(int index2, FileChannel out, long position2, int length2, boolean internal) throws IOException {
        this.checkIndex(index2, length2);
        index2 = this.idx(index2);
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ByteBuffer.wrap((byte[])this.memory);
        return out.write((ByteBuffer)tmpBuf.clear().position(index2).limit(index2 + length2), position2);
    }

    @Override
    public final int readBytes(GatheringByteChannel out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes2 = this.getBytes(this.readerIndex, out, length2, true);
        this.readerIndex += readBytes2;
        return readBytes2;
    }

    @Override
    public final int readBytes(FileChannel out, long position2, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes2 = this.getBytes(this.readerIndex, out, position2, length2, true);
        this.readerIndex += readBytes2;
        return readBytes2;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        HeapByteBufUtil.setByte((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setShort(int index2, int value2) {
        HeapByteBufUtil.setShort((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setShortLE(int index2, int value2) {
        HeapByteBufUtil.setShortLE((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        HeapByteBufUtil.setMedium((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setMediumLE(int index2, int value2) {
        HeapByteBufUtil.setMediumLE((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setInt(int index2, int value2) {
        HeapByteBufUtil.setInt((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setIntLE(int index2, int value2) {
        HeapByteBufUtil.setIntLE((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setLong(int index2, long value2) {
        HeapByteBufUtil.setLong((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setLongLE(int index2, long value2) {
        HeapByteBufUtil.setLongLE((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    public final ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.capacity());
        if (src.hasMemoryAddress()) {
            PlatformDependent.copyMemory(src.memoryAddress() + (long)srcIndex, (byte[])this.memory, this.idx(index2), (long)length2);
        } else if (src.hasArray()) {
            this.setBytes(index2, src.array(), src.arrayOffset() + srcIndex, length2);
        } else {
            src.getBytes(srcIndex, (byte[])this.memory, this.idx(index2), length2);
        }
        return this;
    }

    @Override
    public final ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.length);
        System.arraycopy(src, srcIndex, this.memory, this.idx(index2), length2);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int index2, ByteBuffer src) {
        int length2 = src.remaining();
        this.checkIndex(index2, length2);
        src.get((byte[])this.memory, this.idx(index2), length2);
        return this;
    }

    @Override
    public final int setBytes(int index2, InputStream in2, int length2) throws IOException {
        this.checkIndex(index2, length2);
        return in2.read((byte[])this.memory, this.idx(index2), length2);
    }

    @Override
    public final int setBytes(int index2, ScatteringByteChannel in2, int length2) throws IOException {
        this.checkIndex(index2, length2);
        index2 = this.idx(index2);
        try {
            return in2.read((ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length2));
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public final int setBytes(int index2, FileChannel in2, long position2, int length2) throws IOException {
        this.checkIndex(index2, length2);
        index2 = this.idx(index2);
        try {
            return in2.read((ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length2), position2);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public final ByteBuf copy(int index2, int length2) {
        this.checkIndex(index2, length2);
        ByteBuf copy2 = this.alloc().heapBuffer(length2, this.maxCapacity());
        copy2.writeBytes((byte[])this.memory, this.idx(index2), length2);
        return copy2;
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer[] nioBuffers(int index2, int length2) {
        return new ByteBuffer[]{this.nioBuffer(index2, length2)};
    }

    @Override
    public final ByteBuffer nioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        index2 = this.idx(index2);
        ByteBuffer buf = ByteBuffer.wrap((byte[])this.memory, index2, length2);
        return buf.slice();
    }

    @Override
    public final ByteBuffer internalNioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        index2 = this.idx(index2);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length2);
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        this.ensureAccessible();
        return (byte[])this.memory;
    }

    @Override
    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(byte[] memory) {
        return ByteBuffer.wrap(memory);
    }
}

