/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBufUtil;
import play.shaded.ahc.io.netty.buffer.PooledByteBuf;
import play.shaded.ahc.io.netty.util.Recycler;

final class PooledDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final Recycler<PooledDirectByteBuf> RECYCLER = new Recycler<PooledDirectByteBuf>(){

        @Override
        protected PooledDirectByteBuf newObject(Recycler.Handle<PooledDirectByteBuf> handle) {
            return new PooledDirectByteBuf(handle, 0);
        }
    };

    static PooledDirectByteBuf newInstance(int maxCapacity) {
        PooledDirectByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    private PooledDirectByteBuf(Recycler.Handle<PooledDirectByteBuf> recyclerHandle, int maxCapacity) {
        super(recyclerHandle, maxCapacity);
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer memory) {
        return memory.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    protected byte _getByte(int index2) {
        return ((ByteBuffer)this.memory).get(this.idx(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return ((ByteBuffer)this.memory).getShort(this.idx(index2));
    }

    @Override
    protected short _getShortLE(int index2) {
        return ByteBufUtil.swapShort(this._getShort(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        index2 = this.idx(index2);
        return (((ByteBuffer)this.memory).get(index2) & 0xFF) << 16 | (((ByteBuffer)this.memory).get(index2 + 1) & 0xFF) << 8 | ((ByteBuffer)this.memory).get(index2 + 2) & 0xFF;
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        index2 = this.idx(index2);
        return ((ByteBuffer)this.memory).get(index2) & 0xFF | (((ByteBuffer)this.memory).get(index2 + 1) & 0xFF) << 8 | (((ByteBuffer)this.memory).get(index2 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getInt(int index2) {
        return ((ByteBuffer)this.memory).getInt(this.idx(index2));
    }

    @Override
    protected int _getIntLE(int index2) {
        return ByteBufUtil.swapInt(this._getInt(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return ((ByteBuffer)this.memory).getLong(this.idx(index2));
    }

    @Override
    protected long _getLongLE(int index2) {
        return ByteBufUtil.swapLong(this._getLong(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        this.checkDstIndex(index2, length2, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            this.getBytes(index2, dst.array(), dst.arrayOffset() + dstIndex, length2);
        } else if (dst.nioBufferCount() > 0) {
            for (ByteBuffer bb : dst.nioBuffers(dstIndex, length2)) {
                int bbLen = bb.remaining();
                this.getBytes(index2, bb);
                index2 += bbLen;
            }
        } else {
            dst.setBytes(dstIndex, this, index2, length2);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.getBytes(index2, dst, dstIndex, length2, false);
        return this;
    }

    private void getBytes(int index2, byte[] dst, int dstIndex, int length2, boolean internal) {
        this.checkDstIndex(index2, length2, dstIndex, dst.length);
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length2);
        tmpBuf.get(dst, dstIndex, length2);
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length2) {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst, dstIndex, length2, true);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.getBytes(index2, dst, false);
        return this;
    }

    private void getBytes(int index2, ByteBuffer dst, boolean internal) {
        this.checkIndex(index2, dst.remaining());
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + dst.remaining());
        dst.put(tmpBuf);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        int length2 = dst.remaining();
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst, true);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length2) throws IOException {
        this.getBytes(index2, out, length2, false);
        return this;
    }

    private void getBytes(int index2, OutputStream out, int length2, boolean internal) throws IOException {
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return;
        }
        ByteBufUtil.readBytes(this.alloc(), internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate(), this.idx(index2), length2, out);
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, out, length2, true);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        return this.getBytes(index2, out, length2, false);
    }

    private int getBytes(int index2, GatheringByteChannel out, int length2, boolean internal) throws IOException {
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length2);
        return out.write(tmpBuf);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position2, int length2) throws IOException {
        return this.getBytes(index2, out, position2, length2, false);
    }

    private int getBytes(int index2, FileChannel out, long position2, int length2, boolean internal) throws IOException {
        this.checkIndex(index2, length2);
        if (length2 == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length2);
        return out.write(tmpBuf, position2);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes2 = this.getBytes(this.readerIndex, out, length2, true);
        this.readerIndex += readBytes2;
        return readBytes2;
    }

    @Override
    public int readBytes(FileChannel out, long position2, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes2 = this.getBytes(this.readerIndex, out, position2, length2, true);
        this.readerIndex += readBytes2;
        return readBytes2;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        ((ByteBuffer)this.memory).put(this.idx(index2), (byte)value2);
    }

    @Override
    protected void _setShort(int index2, int value2) {
        ((ByteBuffer)this.memory).putShort(this.idx(index2), (short)value2);
    }

    @Override
    protected void _setShortLE(int index2, int value2) {
        this._setShort(index2, ByteBufUtil.swapShort((short)value2));
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        index2 = this.idx(index2);
        ((ByteBuffer)this.memory).put(index2, (byte)(value2 >>> 16));
        ((ByteBuffer)this.memory).put(index2 + 1, (byte)(value2 >>> 8));
        ((ByteBuffer)this.memory).put(index2 + 2, (byte)value2);
    }

    @Override
    protected void _setMediumLE(int index2, int value2) {
        index2 = this.idx(index2);
        ((ByteBuffer)this.memory).put(index2, (byte)value2);
        ((ByteBuffer)this.memory).put(index2 + 1, (byte)(value2 >>> 8));
        ((ByteBuffer)this.memory).put(index2 + 2, (byte)(value2 >>> 16));
    }

    @Override
    protected void _setInt(int index2, int value2) {
        ((ByteBuffer)this.memory).putInt(this.idx(index2), value2);
    }

    @Override
    protected void _setIntLE(int index2, int value2) {
        this._setInt(index2, ByteBufUtil.swapInt(value2));
    }

    @Override
    protected void _setLong(int index2, long value2) {
        ((ByteBuffer)this.memory).putLong(this.idx(index2), value2);
    }

    @Override
    protected void _setLongLE(int index2, long value2) {
        this._setLong(index2, ByteBufUtil.swapLong(value2));
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.capacity());
        if (src.hasArray()) {
            this.setBytes(index2, src.array(), src.arrayOffset() + srcIndex, length2);
        } else if (src.nioBufferCount() > 0) {
            for (ByteBuffer bb : src.nioBuffers(srcIndex, length2)) {
                int bbLen = bb.remaining();
                this.setBytes(index2, bb);
                index2 += bbLen;
            }
        } else {
            src.getBytes(srcIndex, this, index2, length2);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.length);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length2);
        tmpBuf.put(src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.checkIndex(index2, src.remaining());
        ByteBuffer tmpBuf = this.internalNioBuffer();
        if (src == tmpBuf) {
            src = src.duplicate();
        }
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + src.remaining());
        tmpBuf.put(src);
        return this;
    }

    @Override
    public int setBytes(int index2, InputStream in2, int length2) throws IOException {
        this.checkIndex(index2, length2);
        byte[] tmp = new byte[length2];
        int readBytes2 = in2.read(tmp);
        if (readBytes2 <= 0) {
            return readBytes2;
        }
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(this.idx(index2));
        tmpBuf.put(tmp, 0, readBytes2);
        return readBytes2;
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in2, int length2) throws IOException {
        this.checkIndex(index2, length2);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length2);
        try {
            return in2.read(tmpBuf);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public int setBytes(int index2, FileChannel in2, long position2, int length2) throws IOException {
        this.checkIndex(index2, length2);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length2);
        try {
            return in2.read(tmpBuf, position2);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public ByteBuf copy(int index2, int length2) {
        this.checkIndex(index2, length2);
        ByteBuf copy2 = this.alloc().directBuffer(length2, this.maxCapacity());
        copy2.writeBytes(this, index2, length2);
        return copy2;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        index2 = this.idx(index2);
        return ((ByteBuffer)((ByteBuffer)this.memory).duplicate().position(index2).limit(index2 + length2)).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length2) {
        return new ByteBuffer[]{this.nioBuffer(index2, length2)};
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        index2 = this.idx(index2);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length2);
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }
}

