/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import play.shaded.ahc.io.netty.buffer.AbstractReferenceCountedByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBufAllocator;
import play.shaded.ahc.io.netty.buffer.PoolChunk;
import play.shaded.ahc.io.netty.buffer.PoolThreadCache;
import play.shaded.ahc.io.netty.buffer.PooledDuplicatedByteBuf;
import play.shaded.ahc.io.netty.buffer.PooledSlicedByteBuf;
import play.shaded.ahc.io.netty.util.Recycler;

abstract class PooledByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final Recycler.Handle<PooledByteBuf<T>> recyclerHandle;
    protected PoolChunk<T> chunk;
    protected long handle;
    protected T memory;
    protected int offset;
    protected int length;
    int maxLength;
    PoolThreadCache cache;
    private ByteBuffer tmpNioBuf;
    private ByteBufAllocator allocator;

    protected PooledByteBuf(Recycler.Handle<? extends PooledByteBuf<T>> recyclerHandle, int maxCapacity) {
        super(maxCapacity);
        this.recyclerHandle = recyclerHandle;
    }

    void init(PoolChunk<T> chunk, long handle, int offset, int length2, int maxLength, PoolThreadCache cache) {
        this.init0(chunk, handle, offset, length2, maxLength, cache);
    }

    void initUnpooled(PoolChunk<T> chunk, int length2) {
        this.init0(chunk, 0L, chunk.offset, length2, length2, null);
    }

    private void init0(PoolChunk<T> chunk, long handle, int offset, int length2, int maxLength, PoolThreadCache cache) {
        assert (handle >= 0L);
        assert (chunk != null);
        this.chunk = chunk;
        this.memory = chunk.memory;
        this.allocator = chunk.arena.parent;
        this.cache = cache;
        this.handle = handle;
        this.offset = offset;
        this.length = length2;
        this.maxLength = maxLength;
        this.tmpNioBuf = null;
    }

    final void reuse(int maxCapacity) {
        this.maxCapacity(maxCapacity);
        this.setRefCnt(1);
        this.setIndex0(0, 0);
        this.discardMarks();
    }

    @Override
    public final int capacity() {
        return this.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final ByteBuf capacity(int newCapacity) {
        this.checkNewCapacity(newCapacity);
        if (this.chunk.unpooled) {
            if (newCapacity == this.length) {
                return this;
            }
        } else if (newCapacity > this.length) {
            if (newCapacity <= this.maxLength) {
                this.length = newCapacity;
                return this;
            }
        } else {
            if (newCapacity >= this.length) return this;
            if (newCapacity > this.maxLength >>> 1) {
                if (this.maxLength <= 512) {
                    if (newCapacity > this.maxLength - 16) {
                        this.length = newCapacity;
                        this.setIndex(Math.min(this.readerIndex(), newCapacity), Math.min(this.writerIndex(), newCapacity));
                        return this;
                    }
                } else {
                    this.length = newCapacity;
                    this.setIndex(Math.min(this.readerIndex(), newCapacity), Math.min(this.writerIndex(), newCapacity));
                    return this;
                }
            }
        }
        this.chunk.arena.reallocate(this, newCapacity, true);
        return this;
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this, this, this.readerIndex(), this.writerIndex());
    }

    @Override
    public final ByteBuf retainedSlice() {
        int index2 = this.readerIndex();
        return this.retainedSlice(index2, this.writerIndex() - index2);
    }

    @Override
    public final ByteBuf retainedSlice(int index2, int length2) {
        return PooledSlicedByteBuf.newInstance(this, this, index2, length2);
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = this.newInternalNioBuffer(this.memory);
        }
        return tmpNioBuf;
    }

    protected abstract ByteBuffer newInternalNioBuffer(T var1);

    @Override
    protected final void deallocate() {
        if (this.handle >= 0L) {
            long handle = this.handle;
            this.handle = -1L;
            this.memory = null;
            this.tmpNioBuf = null;
            this.chunk.arena.free(this.chunk, handle, this.maxLength, this.cache);
            this.chunk = null;
            this.recycle();
        }
    }

    private void recycle() {
        this.recyclerHandle.recycle(this);
    }

    protected final int idx(int index2) {
        return this.offset + index2;
    }
}

