/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBufUtil;
import play.shaded.ahc.io.netty.buffer.SwappedByteBuf;
import play.shaded.ahc.io.netty.buffer.Unpooled;
import play.shaded.ahc.io.netty.buffer.UnpooledDuplicatedByteBuf;
import play.shaded.ahc.io.netty.buffer.UnpooledSlicedByteBuf;
import play.shaded.ahc.io.netty.util.ByteProcessor;
import play.shaded.ahc.io.netty.util.CharsetUtil;
import play.shaded.ahc.io.netty.util.IllegalReferenceCountException;
import play.shaded.ahc.io.netty.util.ResourceLeakDetector;
import play.shaded.ahc.io.netty.util.ResourceLeakDetectorFactory;
import play.shaded.ahc.io.netty.util.internal.MathUtil;
import play.shaded.ahc.io.netty.util.internal.PlatformDependent;
import play.shaded.ahc.io.netty.util.internal.StringUtil;
import play.shaded.ahc.io.netty.util.internal.SystemPropertyUtil;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLogger;
import play.shaded.ahc.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class AbstractByteBuf
extends ByteBuf {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractByteBuf.class);
    private static final String LEGACY_PROP_CHECK_ACCESSIBLE = "play.shaded.ahc.io.netty.buffer.bytebuf.checkAccessible";
    private static final String PROP_CHECK_ACCESSIBLE = "play.shaded.ahc.io.netty.buffer.checkAccessible";
    private static final boolean checkAccessible = SystemPropertyUtil.contains("play.shaded.ahc.io.netty.buffer.checkAccessible") ? SystemPropertyUtil.getBoolean("play.shaded.ahc.io.netty.buffer.checkAccessible", true) : SystemPropertyUtil.getBoolean("play.shaded.ahc.io.netty.buffer.bytebuf.checkAccessible", true);
    private static final String PROP_CHECK_BOUNDS = "play.shaded.ahc.io.netty.buffer.checkBounds";
    private static final boolean checkBounds = SystemPropertyUtil.getBoolean("play.shaded.ahc.io.netty.buffer.checkBounds", true);
    static final ResourceLeakDetector<ByteBuf> leakDetector;
    int readerIndex;
    int writerIndex;
    private int markedReaderIndex;
    private int markedWriterIndex;
    private int maxCapacity;

    protected AbstractByteBuf(int maxCapacity) {
        if (maxCapacity < 0) {
            throw new IllegalArgumentException("maxCapacity: " + maxCapacity + " (expected: >= 0)");
        }
        this.maxCapacity = maxCapacity;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuf asReadOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public int maxCapacity() {
        return this.maxCapacity;
    }

    protected final void maxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    private static void checkIndexBounds(int readerIndex, int writerIndex, int capacity) {
        if (readerIndex < 0 || readerIndex > writerIndex || writerIndex > capacity) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected: 0 <= readerIndex <= writerIndex <= capacity(%d))", readerIndex, writerIndex, capacity));
        }
    }

    @Override
    public ByteBuf readerIndex(int readerIndex) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(readerIndex, this.writerIndex, this.capacity());
        }
        this.readerIndex = readerIndex;
        return this;
    }

    @Override
    public int writerIndex() {
        return this.writerIndex;
    }

    @Override
    public ByteBuf writerIndex(int writerIndex) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(this.readerIndex, writerIndex, this.capacity());
        }
        this.writerIndex = writerIndex;
        return this;
    }

    @Override
    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(readerIndex, writerIndex, this.capacity());
        }
        this.setIndex0(readerIndex, writerIndex);
        return this;
    }

    @Override
    public ByteBuf clear() {
        this.writerIndex = 0;
        this.readerIndex = 0;
        return this;
    }

    @Override
    public boolean isReadable() {
        return this.writerIndex > this.readerIndex;
    }

    @Override
    public boolean isReadable(int numBytes) {
        return this.writerIndex - this.readerIndex >= numBytes;
    }

    @Override
    public boolean isWritable() {
        return this.capacity() > this.writerIndex;
    }

    @Override
    public boolean isWritable(int numBytes) {
        return this.capacity() - this.writerIndex >= numBytes;
    }

    @Override
    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    @Override
    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    @Override
    public int maxWritableBytes() {
        return this.maxCapacity() - this.writerIndex;
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.readerIndex(this.markedReaderIndex);
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        this.markedWriterIndex = this.writerIndex;
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        this.writerIndex(this.markedWriterIndex);
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        this.ensureAccessible();
        if (this.readerIndex == 0) {
            return this;
        }
        if (this.readerIndex != this.writerIndex) {
            this.setBytes(0, this, this.readerIndex, this.writerIndex - this.readerIndex);
            this.writerIndex -= this.readerIndex;
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
        } else {
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
            this.writerIndex = 0;
        }
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        this.ensureAccessible();
        if (this.readerIndex == 0) {
            return this;
        }
        if (this.readerIndex == this.writerIndex) {
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
            this.writerIndex = 0;
            return this;
        }
        if (this.readerIndex >= this.capacity() >>> 1) {
            this.setBytes(0, this, this.readerIndex, this.writerIndex - this.readerIndex);
            this.writerIndex -= this.readerIndex;
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
        }
        return this;
    }

    protected final void adjustMarkers(int decrement) {
        int markedReaderIndex = this.markedReaderIndex;
        if (markedReaderIndex <= decrement) {
            this.markedReaderIndex = 0;
            int markedWriterIndex = this.markedWriterIndex;
            this.markedWriterIndex = markedWriterIndex <= decrement ? 0 : markedWriterIndex - decrement;
        } else {
            this.markedReaderIndex = markedReaderIndex - decrement;
            this.markedWriterIndex -= decrement;
        }
    }

    @Override
    public ByteBuf ensureWritable(int minWritableBytes) {
        if (minWritableBytes < 0) {
            throw new IllegalArgumentException(String.format("minWritableBytes: %d (expected: >= 0)", minWritableBytes));
        }
        this.ensureWritable0(minWritableBytes);
        return this;
    }

    final void ensureWritable0(int minWritableBytes) {
        this.ensureAccessible();
        if (minWritableBytes <= this.writableBytes()) {
            return;
        }
        if (checkBounds && minWritableBytes > this.maxCapacity - this.writerIndex) {
            throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + minWritableBytes(%d) exceeds maxCapacity(%d): %s", this.writerIndex, minWritableBytes, this.maxCapacity, this));
        }
        int newCapacity = this.alloc().calculateNewCapacity(this.writerIndex + minWritableBytes, this.maxCapacity);
        this.capacity(newCapacity);
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        int writerIndex;
        this.ensureAccessible();
        if (minWritableBytes < 0) {
            throw new IllegalArgumentException(String.format("minWritableBytes: %d (expected: >= 0)", minWritableBytes));
        }
        if (minWritableBytes <= this.writableBytes()) {
            return 0;
        }
        int maxCapacity = this.maxCapacity();
        if (minWritableBytes > maxCapacity - (writerIndex = this.writerIndex())) {
            if (!force || this.capacity() == maxCapacity) {
                return 1;
            }
            this.capacity(maxCapacity);
            return 3;
        }
        int newCapacity = this.alloc().calculateNewCapacity(writerIndex + minWritableBytes, maxCapacity);
        this.capacity(newCapacity);
        return 2;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (endianness == this.order()) {
            return this;
        }
        return this.newSwappedByteBuf();
    }

    protected SwappedByteBuf newSwappedByteBuf() {
        return new SwappedByteBuf(this);
    }

    @Override
    public byte getByte(int index2) {
        this.checkIndex(index2);
        return this._getByte(index2);
    }

    protected abstract byte _getByte(int var1);

    @Override
    public boolean getBoolean(int index2) {
        return this.getByte(index2) != 0;
    }

    @Override
    public short getUnsignedByte(int index2) {
        return (short)(this.getByte(index2) & 0xFF);
    }

    @Override
    public short getShort(int index2) {
        this.checkIndex(index2, 2);
        return this._getShort(index2);
    }

    protected abstract short _getShort(int var1);

    @Override
    public short getShortLE(int index2) {
        this.checkIndex(index2, 2);
        return this._getShortLE(index2);
    }

    protected abstract short _getShortLE(int var1);

    @Override
    public int getUnsignedShort(int index2) {
        return this.getShort(index2) & 0xFFFF;
    }

    @Override
    public int getUnsignedShortLE(int index2) {
        return this.getShortLE(index2) & 0xFFFF;
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.checkIndex(index2, 3);
        return this._getUnsignedMedium(index2);
    }

    protected abstract int _getUnsignedMedium(int var1);

    @Override
    public int getUnsignedMediumLE(int index2) {
        this.checkIndex(index2, 3);
        return this._getUnsignedMediumLE(index2);
    }

    protected abstract int _getUnsignedMediumLE(int var1);

    @Override
    public int getMedium(int index2) {
        int value2 = this.getUnsignedMedium(index2);
        if ((value2 & 0x800000) != 0) {
            value2 |= 0xFF000000;
        }
        return value2;
    }

    @Override
    public int getMediumLE(int index2) {
        int value2 = this.getUnsignedMediumLE(index2);
        if ((value2 & 0x800000) != 0) {
            value2 |= 0xFF000000;
        }
        return value2;
    }

    @Override
    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        return this._getInt(index2);
    }

    protected abstract int _getInt(int var1);

    @Override
    public int getIntLE(int index2) {
        this.checkIndex(index2, 4);
        return this._getIntLE(index2);
    }

    protected abstract int _getIntLE(int var1);

    @Override
    public long getUnsignedInt(int index2) {
        return (long)this.getInt(index2) & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedIntLE(int index2) {
        return (long)this.getIntLE(index2) & 0xFFFFFFFFL;
    }

    @Override
    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        return this._getLong(index2);
    }

    protected abstract long _getLong(int var1);

    @Override
    public long getLongLE(int index2) {
        this.checkIndex(index2, 8);
        return this._getLongLE(index2);
    }

    protected abstract long _getLongLE(int var1);

    @Override
    public char getChar(int index2) {
        return (char)this.getShort(index2);
    }

    @Override
    public float getFloat(int index2) {
        return Float.intBitsToFloat(this.getInt(index2));
    }

    @Override
    public double getDouble(int index2) {
        return Double.longBitsToDouble(this.getLong(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst) {
        this.getBytes(index2, dst, 0, dst.length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst) {
        this.getBytes(index2, dst, dst.writableBytes());
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int length2) {
        this.getBytes(index2, dst, dst.writerIndex(), length2);
        dst.writerIndex(dst.writerIndex() + length2);
        return this;
    }

    @Override
    public CharSequence getCharSequence(int index2, int length2, Charset charset) {
        return this.toString(index2, length2, charset);
    }

    @Override
    public CharSequence readCharSequence(int length2, Charset charset) {
        CharSequence sequence2 = this.getCharSequence(this.readerIndex, length2, charset);
        this.readerIndex += length2;
        return sequence2;
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        this.checkIndex(index2);
        this._setByte(index2, value2);
        return this;
    }

    protected abstract void _setByte(int var1, int var2);

    @Override
    public ByteBuf setBoolean(int index2, boolean value2) {
        this.setByte(index2, value2 ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        this.checkIndex(index2, 2);
        this._setShort(index2, value2);
        return this;
    }

    protected abstract void _setShort(int var1, int var2);

    @Override
    public ByteBuf setShortLE(int index2, int value2) {
        this.checkIndex(index2, 2);
        this._setShortLE(index2, value2);
        return this;
    }

    protected abstract void _setShortLE(int var1, int var2);

    @Override
    public ByteBuf setChar(int index2, int value2) {
        this.setShort(index2, value2);
        return this;
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        this.checkIndex(index2, 3);
        this._setMedium(index2, value2);
        return this;
    }

    protected abstract void _setMedium(int var1, int var2);

    @Override
    public ByteBuf setMediumLE(int index2, int value2) {
        this.checkIndex(index2, 3);
        this._setMediumLE(index2, value2);
        return this;
    }

    protected abstract void _setMediumLE(int var1, int var2);

    @Override
    public ByteBuf setInt(int index2, int value2) {
        this.checkIndex(index2, 4);
        this._setInt(index2, value2);
        return this;
    }

    protected abstract void _setInt(int var1, int var2);

    @Override
    public ByteBuf setIntLE(int index2, int value2) {
        this.checkIndex(index2, 4);
        this._setIntLE(index2, value2);
        return this;
    }

    protected abstract void _setIntLE(int var1, int var2);

    @Override
    public ByteBuf setFloat(int index2, float value2) {
        this.setInt(index2, Float.floatToRawIntBits(value2));
        return this;
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        this.checkIndex(index2, 8);
        this._setLong(index2, value2);
        return this;
    }

    protected abstract void _setLong(int var1, long var2);

    @Override
    public ByteBuf setLongLE(int index2, long value2) {
        this.checkIndex(index2, 8);
        this._setLongLE(index2, value2);
        return this;
    }

    protected abstract void _setLongLE(int var1, long var2);

    @Override
    public ByteBuf setDouble(int index2, double value2) {
        this.setLong(index2, Double.doubleToRawLongBits(value2));
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src) {
        this.setBytes(index2, src, 0, src.length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src) {
        this.setBytes(index2, src, src.readableBytes());
        return this;
    }

    private static void checkReadableBounds(ByteBuf src, int length2) {
        if (length2 > src.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", length2, src.readableBytes(), src));
        }
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int length2) {
        this.checkIndex(index2, length2);
        if (src == null) {
            throw new NullPointerException("src");
        }
        if (checkBounds) {
            AbstractByteBuf.checkReadableBounds(src, length2);
        }
        this.setBytes(index2, src, src.readerIndex(), length2);
        src.readerIndex(src.readerIndex() + length2);
        return this;
    }

    @Override
    public ByteBuf setZero(int index2, int length2) {
        int i;
        if (length2 == 0) {
            return this;
        }
        this.checkIndex(index2, length2);
        int nLong = length2 >>> 3;
        int nBytes = length2 & 7;
        for (i = nLong; i > 0; --i) {
            this._setLong(index2, 0L);
            index2 += 8;
        }
        if (nBytes == 4) {
            this._setInt(index2, 0);
        } else if (nBytes < 4) {
            for (i = nBytes; i > 0; --i) {
                this._setByte(index2, 0);
                ++index2;
            }
        } else {
            this._setInt(index2, 0);
            index2 += 4;
            for (i = nBytes - 4; i > 0; --i) {
                this._setByte(index2, 0);
                ++index2;
            }
        }
        return this;
    }

    @Override
    public int setCharSequence(int index2, CharSequence sequence2, Charset charset) {
        return this.setCharSequence0(index2, sequence2, charset, false);
    }

    private int setCharSequence0(int index2, CharSequence sequence2, Charset charset, boolean expand2) {
        if (charset.equals(CharsetUtil.UTF_8)) {
            int length2 = ByteBufUtil.utf8MaxBytes(sequence2);
            if (expand2) {
                this.ensureWritable0(length2);
                this.checkIndex0(index2, length2);
            } else {
                this.checkIndex(index2, length2);
            }
            return ByteBufUtil.writeUtf8(this, index2, sequence2, sequence2.length());
        }
        if (charset.equals(CharsetUtil.US_ASCII) || charset.equals(CharsetUtil.ISO_8859_1)) {
            int length3 = sequence2.length();
            if (expand2) {
                this.ensureWritable0(length3);
                this.checkIndex0(index2, length3);
            } else {
                this.checkIndex(index2, length3);
            }
            return ByteBufUtil.writeAscii(this, index2, sequence2, length3);
        }
        byte[] bytes2 = sequence2.toString().getBytes(charset);
        if (expand2) {
            this.ensureWritable0(bytes2.length);
        }
        this.setBytes(index2, bytes2);
        return bytes2.length;
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes0(1);
        int i = this.readerIndex;
        byte b2 = this._getByte(i);
        this.readerIndex = i + 1;
        return b2;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public short readShort() {
        this.checkReadableBytes0(2);
        short v = this._getShort(this.readerIndex);
        this.readerIndex += 2;
        return v;
    }

    @Override
    public short readShortLE() {
        this.checkReadableBytes0(2);
        short v = this._getShortLE(this.readerIndex);
        this.readerIndex += 2;
        return v;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShortLE() {
        return this.readShortLE() & 0xFFFF;
    }

    @Override
    public int readMedium() {
        int value2 = this.readUnsignedMedium();
        if ((value2 & 0x800000) != 0) {
            value2 |= 0xFF000000;
        }
        return value2;
    }

    @Override
    public int readMediumLE() {
        int value2 = this.readUnsignedMediumLE();
        if ((value2 & 0x800000) != 0) {
            value2 |= 0xFF000000;
        }
        return value2;
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes0(3);
        int v = this._getUnsignedMedium(this.readerIndex);
        this.readerIndex += 3;
        return v;
    }

    @Override
    public int readUnsignedMediumLE() {
        this.checkReadableBytes0(3);
        int v = this._getUnsignedMediumLE(this.readerIndex);
        this.readerIndex += 3;
        return v;
    }

    @Override
    public int readInt() {
        this.checkReadableBytes0(4);
        int v = this._getInt(this.readerIndex);
        this.readerIndex += 4;
        return v;
    }

    @Override
    public int readIntLE() {
        this.checkReadableBytes0(4);
        int v = this._getIntLE(this.readerIndex);
        this.readerIndex += 4;
        return v;
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedIntLE() {
        return (long)this.readIntLE() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        this.checkReadableBytes0(8);
        long v = this._getLong(this.readerIndex);
        this.readerIndex += 8;
        return v;
    }

    @Override
    public long readLongLE() {
        this.checkReadableBytes0(8);
        long v = this._getLongLE(this.readerIndex);
        this.readerIndex += 8;
        return v;
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public ByteBuf readBytes(int length2) {
        this.checkReadableBytes(length2);
        if (length2 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf buf = this.alloc().buffer(length2, this.maxCapacity);
        buf.writeBytes(this, this.readerIndex, length2);
        this.readerIndex += length2;
        return buf;
    }

    @Override
    public ByteBuf readSlice(int length2) {
        this.checkReadableBytes(length2);
        ByteBuf slice2 = this.slice(this.readerIndex, length2);
        this.readerIndex += length2;
        return slice2;
    }

    @Override
    public ByteBuf readRetainedSlice(int length2) {
        this.checkReadableBytes(length2);
        ByteBuf slice2 = this.retainedSlice(this.readerIndex, length2);
        this.readerIndex += length2;
        return slice2;
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length2) {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst, dstIndex, length2);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst) {
        this.readBytes(dst, dst.writableBytes());
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int length2) {
        if (checkBounds && length2 > dst.writableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds dst.writableBytes(%d) where dst is: %s", length2, dst.writableBytes(), dst));
        }
        this.readBytes(dst, dst.writerIndex(), length2);
        dst.writerIndex(dst.writerIndex() + length2);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length2) {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst, dstIndex, length2);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        int length2 = dst.remaining();
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes2 = this.getBytes(this.readerIndex, out, length2);
        this.readerIndex += readBytes2;
        return readBytes2;
    }

    @Override
    public int readBytes(FileChannel out, long position2, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes2 = this.getBytes(this.readerIndex, out, position2, length2);
        this.readerIndex += readBytes2;
        return readBytes2;
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, out, length2);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf skipBytes(int length2) {
        this.checkReadableBytes(length2);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf writeBoolean(boolean value2) {
        this.writeByte(value2 ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf writeByte(int value2) {
        this.ensureWritable0(1);
        this._setByte(this.writerIndex++, value2);
        return this;
    }

    @Override
    public ByteBuf writeShort(int value2) {
        this.ensureWritable0(2);
        this._setShort(this.writerIndex, value2);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeShortLE(int value2) {
        this.ensureWritable0(2);
        this._setShortLE(this.writerIndex, value2);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeMedium(int value2) {
        this.ensureWritable0(3);
        this._setMedium(this.writerIndex, value2);
        this.writerIndex += 3;
        return this;
    }

    @Override
    public ByteBuf writeMediumLE(int value2) {
        this.ensureWritable0(3);
        this._setMediumLE(this.writerIndex, value2);
        this.writerIndex += 3;
        return this;
    }

    @Override
    public ByteBuf writeInt(int value2) {
        this.ensureWritable0(4);
        this._setInt(this.writerIndex, value2);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeIntLE(int value2) {
        this.ensureWritable0(4);
        this._setIntLE(this.writerIndex, value2);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long value2) {
        this.ensureWritable0(8);
        this._setLong(this.writerIndex, value2);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeLongLE(long value2) {
        this.ensureWritable0(8);
        this._setLongLE(this.writerIndex, value2);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeChar(int value2) {
        this.writeShort(value2);
        return this;
    }

    @Override
    public ByteBuf writeFloat(float value2) {
        this.writeInt(Float.floatToRawIntBits(value2));
        return this;
    }

    @Override
    public ByteBuf writeDouble(double value2) {
        this.writeLong(Double.doubleToRawLongBits(value2));
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] src, int srcIndex, int length2) {
        this.ensureWritable(length2);
        this.setBytes(this.writerIndex, src, srcIndex, length2);
        this.writerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] src) {
        this.writeBytes(src, 0, src.length);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src) {
        this.writeBytes(src, src.readableBytes());
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int length2) {
        if (checkBounds) {
            AbstractByteBuf.checkReadableBounds(src, length2);
        }
        this.writeBytes(src, src.readerIndex(), length2);
        src.readerIndex(src.readerIndex() + length2);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length2) {
        this.ensureWritable(length2);
        this.setBytes(this.writerIndex, src, srcIndex, length2);
        this.writerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer src) {
        int length2 = src.remaining();
        this.ensureWritable0(length2);
        this.setBytes(this.writerIndex, src);
        this.writerIndex += length2;
        return this;
    }

    @Override
    public int writeBytes(InputStream in2, int length2) throws IOException {
        this.ensureWritable(length2);
        int writtenBytes = this.setBytes(this.writerIndex, in2, length2);
        if (writtenBytes > 0) {
            this.writerIndex += writtenBytes;
        }
        return writtenBytes;
    }

    @Override
    public int writeBytes(ScatteringByteChannel in2, int length2) throws IOException {
        this.ensureWritable(length2);
        int writtenBytes = this.setBytes(this.writerIndex, in2, length2);
        if (writtenBytes > 0) {
            this.writerIndex += writtenBytes;
        }
        return writtenBytes;
    }

    @Override
    public int writeBytes(FileChannel in2, long position2, int length2) throws IOException {
        this.ensureWritable(length2);
        int writtenBytes = this.setBytes(this.writerIndex, in2, position2, length2);
        if (writtenBytes > 0) {
            this.writerIndex += writtenBytes;
        }
        return writtenBytes;
    }

    @Override
    public ByteBuf writeZero(int length2) {
        int i;
        if (length2 == 0) {
            return this;
        }
        this.ensureWritable(length2);
        int wIndex = this.writerIndex;
        this.checkIndex0(wIndex, length2);
        int nLong = length2 >>> 3;
        int nBytes = length2 & 7;
        for (i = nLong; i > 0; --i) {
            this._setLong(wIndex, 0L);
            wIndex += 8;
        }
        if (nBytes == 4) {
            this._setInt(wIndex, 0);
            wIndex += 4;
        } else if (nBytes < 4) {
            for (i = nBytes; i > 0; --i) {
                this._setByte(wIndex, 0);
                ++wIndex;
            }
        } else {
            this._setInt(wIndex, 0);
            wIndex += 4;
            for (i = nBytes - 4; i > 0; --i) {
                this._setByte(wIndex, 0);
                ++wIndex;
            }
        }
        this.writerIndex = wIndex;
        return this;
    }

    @Override
    public int writeCharSequence(CharSequence sequence2, Charset charset) {
        int written2 = this.setCharSequence0(this.writerIndex, sequence2, charset, true);
        this.writerIndex += written2;
        return written2;
    }

    @Override
    public ByteBuf copy() {
        return this.copy(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuf duplicate() {
        this.ensureAccessible();
        return new UnpooledDuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.duplicate().retain();
    }

    @Override
    public ByteBuf slice() {
        return this.slice(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuf retainedSlice() {
        return this.slice().retain();
    }

    @Override
    public ByteBuf slice(int index2, int length2) {
        this.ensureAccessible();
        return new UnpooledSlicedByteBuf(this, index2, length2);
    }

    @Override
    public ByteBuf retainedSlice(int index2, int length2) {
        return this.slice(index2, length2).retain();
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex, this.readableBytes());
    }

    @Override
    public String toString(Charset charset) {
        return this.toString(this.readerIndex, this.readableBytes(), charset);
    }

    @Override
    public String toString(int index2, int length2, Charset charset) {
        return ByteBufUtil.decodeString(this, index2, length2, charset);
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value2) {
        return ByteBufUtil.indexOf(this, fromIndex, toIndex, value2);
    }

    @Override
    public int bytesBefore(byte value2) {
        return this.bytesBefore(this.readerIndex(), this.readableBytes(), value2);
    }

    @Override
    public int bytesBefore(int length2, byte value2) {
        this.checkReadableBytes(length2);
        return this.bytesBefore(this.readerIndex(), length2, value2);
    }

    @Override
    public int bytesBefore(int index2, int length2, byte value2) {
        int endIndex = this.indexOf(index2, index2 + length2, value2);
        if (endIndex < 0) {
            return -1;
        }
        return endIndex - index2;
    }

    @Override
    public int forEachByte(ByteProcessor processor) {
        this.ensureAccessible();
        try {
            return this.forEachByteAsc0(this.readerIndex, this.writerIndex, processor);
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return -1;
        }
    }

    @Override
    public int forEachByte(int index2, int length2, ByteProcessor processor) {
        this.checkIndex(index2, length2);
        try {
            return this.forEachByteAsc0(index2, index2 + length2, processor);
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return -1;
        }
    }

    private int forEachByteAsc0(int start2, int end, ByteProcessor processor) throws Exception {
        while (start2 < end) {
            if (!processor.process(this._getByte(start2))) {
                return start2;
            }
            ++start2;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(ByteProcessor processor) {
        this.ensureAccessible();
        try {
            return this.forEachByteDesc0(this.writerIndex - 1, this.readerIndex, processor);
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return -1;
        }
    }

    @Override
    public int forEachByteDesc(int index2, int length2, ByteProcessor processor) {
        this.checkIndex(index2, length2);
        try {
            return this.forEachByteDesc0(index2 + length2 - 1, index2, processor);
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return -1;
        }
    }

    private int forEachByteDesc0(int rStart, int rEnd, ByteProcessor processor) throws Exception {
        while (rStart >= rEnd) {
            if (!processor.process(this._getByte(rStart))) {
                return rStart;
            }
            --rStart;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return ByteBufUtil.hashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof ByteBuf && ByteBufUtil.equals(this, (ByteBuf)o);
    }

    @Override
    public int compareTo(ByteBuf that2) {
        return ByteBufUtil.compare(this, that2);
    }

    @Override
    public String toString() {
        ByteBuf unwrapped;
        if (this.refCnt() == 0) {
            return StringUtil.simpleClassName(this) + "(freed)";
        }
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName(this)).append("(ridx: ").append(this.readerIndex).append(", widx: ").append(this.writerIndex).append(", cap: ").append(this.capacity());
        if (this.maxCapacity != Integer.MAX_VALUE) {
            buf.append('/').append(this.maxCapacity);
        }
        if ((unwrapped = this.unwrap()) != null) {
            buf.append(", unwrapped: ").append(unwrapped);
        }
        buf.append(')');
        return buf.toString();
    }

    protected final void checkIndex(int index2) {
        this.checkIndex(index2, 1);
    }

    protected final void checkIndex(int index2, int fieldLength) {
        this.ensureAccessible();
        this.checkIndex0(index2, fieldLength);
    }

    private static void checkRangeBounds(int index2, int fieldLength, int capacity) {
        if (MathUtil.isOutOfBounds(index2, fieldLength, capacity)) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index2, fieldLength, capacity));
        }
    }

    final void checkIndex0(int index2, int fieldLength) {
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds(index2, fieldLength, this.capacity());
        }
    }

    protected final void checkSrcIndex(int index2, int length2, int srcIndex, int srcCapacity) {
        this.checkIndex(index2, length2);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds(srcIndex, length2, srcCapacity);
        }
    }

    protected final void checkDstIndex(int index2, int length2, int dstIndex, int dstCapacity) {
        this.checkIndex(index2, length2);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds(dstIndex, length2, dstCapacity);
        }
    }

    protected final void checkReadableBytes(int minimumReadableBytes) {
        if (minimumReadableBytes < 0) {
            throw new IllegalArgumentException("minimumReadableBytes: " + minimumReadableBytes + " (expected: >= 0)");
        }
        this.checkReadableBytes0(minimumReadableBytes);
    }

    protected final void checkNewCapacity(int newCapacity) {
        this.ensureAccessible();
        if (checkBounds && (newCapacity < 0 || newCapacity > this.maxCapacity())) {
            throw new IllegalArgumentException("newCapacity: " + newCapacity + " (expected: 0-" + this.maxCapacity() + ')');
        }
    }

    private void checkReadableBytes0(int minimumReadableBytes) {
        this.ensureAccessible();
        if (checkBounds && this.readerIndex > this.writerIndex - minimumReadableBytes) {
            throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d): %s", this.readerIndex, minimumReadableBytes, this.writerIndex, this));
        }
    }

    protected final void ensureAccessible() {
        if (checkAccessible && this.internalRefCnt() == 0) {
            throw new IllegalReferenceCountException(0);
        }
    }

    int internalRefCnt() {
        return this.refCnt();
    }

    final void setIndex0(int readerIndex, int writerIndex) {
        this.readerIndex = readerIndex;
        this.writerIndex = writerIndex;
    }

    final void discardMarks() {
        this.markedWriterIndex = 0;
        this.markedReaderIndex = 0;
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_CHECK_ACCESSIBLE, (Object)checkAccessible);
            logger.debug("-D{}: {}", (Object)PROP_CHECK_BOUNDS, (Object)checkBounds);
        }
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ByteBuf.class);
    }
}

