/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import akka.stream.javadsl.Source;
import akka.util.ByteString;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import play.api.libs.ws.ahc.AhcWSUtils;
import play.libs.ws.BodyReadable;
import play.libs.ws.StandaloneWSResponse;
import play.libs.ws.WSCookie;
import play.libs.ws.ahc.CookieBuilder;
import play.libs.ws.ahc.StandaloneAhcWSClient;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;
import scala.compat.java8.ScalaStreamSupport;

public class StreamedResponse
implements StandaloneWSResponse,
CookieBuilder {
    private final int status;
    private final java.util.Map<String, List<String>> headers;
    private final String statusText;
    private final URI uri;
    private final Publisher<HttpResponseBodyPart> publisher;
    private final StandaloneAhcWSClient client;
    private final boolean useLaxCookieEncoder;
    private List<WSCookie> cookies;

    public StreamedResponse(StandaloneAhcWSClient standaloneAhcWSClient, int n, String string2, URI uRI, Map<String, Seq<String>> map2, Publisher<HttpResponseBodyPart> publisher, boolean bl) {
        this.client = standaloneAhcWSClient;
        this.status = n;
        this.statusText = string2;
        this.uri = uRI;
        this.headers = StreamedResponse.asJava(map2);
        this.publisher = publisher;
        this.useLaxCookieEncoder = bl;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public java.util.Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public Object getUnderlying() {
        return this.publisher;
    }

    @Override
    public List<WSCookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = this.buildCookies(this.headers);
        }
        return this.cookies;
    }

    @Override
    public Optional<WSCookie> getCookie(String string2) {
        Predicate<WSCookie> predicate = wSCookie -> wSCookie.getName().equals(string2);
        return this.getCookies().stream().filter(predicate).findFirst();
    }

    @Override
    public String getContentType() {
        return this.getSingleHeader("Content-Type").orElse("application/octet-stream");
    }

    @Override
    public <T> T getBody(BodyReadable<T> bodyReadable) {
        return (T)bodyReadable.apply(this);
    }

    @Override
    public String getBody() {
        return this.getBodyAsBytes().decodeString(AhcWSUtils.getCharset(this.getContentType()));
    }

    @Override
    public ByteString getBodyAsBytes() {
        return this.client.blockingToByteString(this.getBodyAsSource());
    }

    @Override
    public Source<ByteString, ?> getBodyAsSource() {
        return Source.fromPublisher(this.publisher).map(httpResponseBodyPart -> ByteString.fromArray(httpResponseBodyPart.getBodyPartBytes()));
    }

    @Override
    public boolean isUseLaxCookieEncoder() {
        return this.useLaxCookieEncoder;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    private static java.util.Map<String, List<String>> asJava(Map<String, Seq<String>> map2) {
        return ScalaStreamSupport.stream(map2).collect(Collectors.toMap(tuple23 -> (String)tuple23._1(), tuple23 -> JavaConverters.seqAsJavaListConverter((Seq)tuple23._2()).asJava()));
    }
}

