/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import akka.util.ByteString;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import play.api.libs.ws.ahc.AhcWSUtils;
import play.libs.ws.BodyReadable;
import play.libs.ws.StandaloneWSResponse;
import play.libs.ws.WSCookie;
import play.libs.ws.WSCookieBuilder;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.org.asynchttpclient.Response;

public class StandaloneAhcWSResponse
implements StandaloneWSResponse {
    private final Response ahcResponse;

    public StandaloneAhcWSResponse(Response response) {
        this.ahcResponse = response;
    }

    @Override
    public Object getUnderlying() {
        return this.ahcResponse;
    }

    @Override
    public int getStatus() {
        return this.ahcResponse.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.ahcResponse.getStatusText();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        HttpHeaders httpHeaders = this.ahcResponse.getHeaders();
        for (String string2 : httpHeaders.names()) {
            List<String> list2 = httpHeaders.getAll(string2);
            treeMap.put(string2, list2);
        }
        return treeMap;
    }

    @Override
    public List<WSCookie> getCookies() {
        return this.ahcResponse.getCookies().stream().map(this::asCookie).collect(Collectors.toList());
    }

    public WSCookie asCookie(Cookie cookie2) {
        return new WSCookieBuilder().setName(cookie2.name()).setValue(cookie2.value()).setDomain(cookie2.domain()).setPath(cookie2.path()).setMaxAge(cookie2.maxAge()).setSecure(cookie2.isSecure()).setHttpOnly(cookie2.isHttpOnly()).build();
    }

    @Override
    public Optional<WSCookie> getCookie(String string2) {
        for (Cookie cookie2 : this.ahcResponse.getCookies()) {
            if (!cookie2.name().equals(string2)) continue;
            return Optional.of(this.asCookie(cookie2));
        }
        return Optional.empty();
    }

    @Override
    public String getBody() {
        return AhcWSUtils.getResponseBody(this.ahcResponse);
    }

    @Override
    public ByteString getBodyAsBytes() {
        return ByteString.fromArray(this.ahcResponse.getResponseBodyAsBytes());
    }

    @Override
    public <T> T getBody(BodyReadable<T> bodyReadable) {
        return (T)bodyReadable.apply(this);
    }

    @Override
    public String getContentType() {
        String string2 = this.ahcResponse.getContentType();
        if (string2 == null) {
            string2 = "application/octet-stream";
        }
        return string2;
    }

    @Override
    public URI getUri() {
        try {
            return this.ahcResponse.getUri().toJavaNetURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

