/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import akka.stream.Materializer;
import akka.stream.javadsl.AsPublisher;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import play.api.libs.ws.ahc.FormUrlEncodedParser;
import play.libs.oauth.OAuth;
import play.libs.ws.BodyWritable;
import play.libs.ws.InMemoryBodyWritable;
import play.libs.ws.SourceBodyWritable;
import play.libs.ws.StandaloneWSRequest;
import play.libs.ws.StandaloneWSResponse;
import play.libs.ws.WSAuthInfo;
import play.libs.ws.WSAuthScheme;
import play.libs.ws.WSCookie;
import play.libs.ws.WSRequestExecutor;
import play.libs.ws.WSRequestFilter;
import play.libs.ws.WSSignatureCalculator;
import play.libs.ws.ahc.StandaloneAhcWSClient;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.Unpooled;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.DefaultCookie;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.RequestBuilder;
import play.shaded.ahc.org.asynchttpclient.SignatureCalculator;
import play.shaded.ahc.org.asynchttpclient.oauth.OAuthSignatureCalculator;
import play.shaded.ahc.org.asynchttpclient.util.HttpUtils;

public class StandaloneAhcWSRequest
implements StandaloneWSRequest {
    private static final Duration INFINITE = Duration.ofMillis(-1L);
    private BodyWritable<?> bodyWritable;
    private String url;
    private String method = "GET";
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();
    private final List<WSCookie> cookies = new ArrayList<WSCookie>();
    private WSAuthInfo auth;
    private WSSignatureCalculator calculator;
    private final StandaloneAhcWSClient client;
    private final Materializer materializer;
    private Duration timeout = Duration.ZERO;
    private Boolean followRedirects = null;
    private String virtualHost = null;
    private final List<WSRequestFilter> filters = new ArrayList<WSRequestFilter>();

    public StandaloneAhcWSRequest(StandaloneAhcWSClient standaloneAhcWSClient, String string2, Materializer materializer) {
        this.client = standaloneAhcWSClient;
        try {
            URL uRL = new URL(string2);
            this.url = string2;
            this.materializer = materializer;
            this.bodyWritable = null;
            String string3 = uRL.getUserInfo();
            if (string3 != null) {
                this.setAuth(string3);
            }
            if (uRL.getQuery() != null) {
                this.setQueryString(uRL.getQuery());
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    @Override
    public StandaloneAhcWSRequest setRequestFilter(WSRequestFilter wSRequestFilter) {
        this.filters.add(wSRequestFilter);
        return this;
    }

    @Override
    public StandaloneAhcWSRequest addHeader(String string2, String string3) {
        StandaloneAhcWSRequest.addValueTo(this.headers, string2, string3);
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setHeaders(Map<String, List<String>> map2) {
        this.headers.clear();
        this.headers.putAll(map2);
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setQueryString(String string2) {
        String[] stringArray;
        for (String string3 : stringArray = string2.split("&")) {
            String[] stringArray2 = string3.split("=");
            if (stringArray2.length > 2) {
                throw new RuntimeException(new MalformedURLException("QueryString parameter should not have more than 2 = per part"));
            }
            if (stringArray2.length == 2) {
                this.addQueryParameter(stringArray2[0], stringArray2[1]);
                continue;
            }
            if (stringArray2.length == 1 && string3.charAt(0) != '=') {
                this.addQueryParameter(stringArray2[0], null);
                continue;
            }
            throw new RuntimeException(new MalformedURLException("QueryString part should not start with an = and not be empty"));
        }
        return this;
    }

    @Override
    public StandaloneAhcWSRequest addQueryParameter(String string2, String string3) {
        StandaloneAhcWSRequest.addValueTo(this.queryParameters, string2, string3);
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setQueryString(Map<String, List<String>> map2) {
        this.queryParameters.clear();
        this.queryParameters.putAll(map2);
        return this;
    }

    @Override
    public StandaloneAhcWSRequest addCookie(WSCookie wSCookie) {
        if (wSCookie == null) {
            throw new NullPointerException("Trying to add a null WSCookie");
        }
        this.cookies.add(wSCookie);
        return this;
    }

    @Override
    public StandaloneAhcWSRequest addCookies(WSCookie ... wSCookieArray) {
        Arrays.asList(wSCookieArray).forEach(this::addCookie);
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setCookies(List<WSCookie> list2) {
        this.cookies.clear();
        list2.forEach(this::addCookie);
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setAuth(String string2) {
        if (string2.isEmpty()) {
            throw new RuntimeException(new MalformedURLException("userInfo should not be empty"));
        }
        int n = string2.indexOf(58);
        this.auth = n == 0 ? new WSAuthInfo("", string2.substring(1), WSAuthScheme.BASIC) : (n == -1 ? new WSAuthInfo(string2, "", WSAuthScheme.BASIC) : new WSAuthInfo(string2.substring(0, n), string2.substring(n + 1), WSAuthScheme.BASIC));
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setAuth(WSAuthInfo wSAuthInfo) {
        this.auth = wSAuthInfo;
        return this;
    }

    @Override
    public StandaloneAhcWSRequest sign(WSSignatureCalculator wSSignatureCalculator) {
        this.calculator = wSSignatureCalculator;
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setVirtualHost(String string2) {
        this.virtualHost = string2;
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setRequestTimeout(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Timeout must not be null.");
        }
        this.timeout = duration;
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setContentType(String string2) {
        return this.addHeader("Content-Type", string2);
    }

    @Override
    public Optional<String> getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public StandaloneAhcWSRequest setUrl(String string2) {
        this.url = string2;
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setMethod(String string2) {
        this.method = string2;
        return this;
    }

    @Override
    public StandaloneAhcWSRequest setBody(BodyWritable bodyWritable) {
        this.bodyWritable = bodyWritable;
        String string2 = bodyWritable.contentType();
        if (!this.headers.containsKey("Content-Type") && string2 != null) {
            this.addHeader("Content-Type", bodyWritable.contentType());
        }
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public List<WSCookie> getCookies() {
        return new ArrayList<WSCookie>(this.cookies);
    }

    @Override
    public Optional<BodyWritable> getBody() {
        return Optional.ofNullable(this.bodyWritable);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return new HashMap<String, List<String>>(this.headers);
    }

    @Override
    public List<String> getHeaderValues(String string2) {
        return this.getHeaders().getOrDefault(string2, Collections.emptyList());
    }

    @Override
    public Optional<String> getHeader(String string2) {
        return this.getHeaderValues(string2).stream().findFirst();
    }

    @Override
    public Map<String, List<String>> getQueryParameters() {
        return new LinkedHashMap<String, List<String>>(this.queryParameters);
    }

    @Override
    public Optional<WSAuthInfo> getAuth() {
        return Optional.ofNullable(this.auth);
    }

    @Override
    public Optional<WSSignatureCalculator> getCalculator() {
        return Optional.ofNullable(this.calculator);
    }

    @Override
    public Optional<Duration> getRequestTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    @Override
    public Optional<Boolean> getFollowRedirects() {
        return Optional.ofNullable(this.followRedirects);
    }

    Optional<String> getVirtualHost() {
        return Optional.ofNullable(this.virtualHost);
    }

    @Override
    public CompletionStage<? extends StandaloneWSResponse> get() {
        return this.execute("GET");
    }

    @Override
    public CompletionStage<? extends StandaloneWSResponse> patch(BodyWritable bodyWritable) {
        return this.setMethod("PATCH").setBody(bodyWritable).execute();
    }

    @Override
    public CompletionStage<? extends StandaloneWSResponse> post(BodyWritable bodyWritable) {
        return this.setMethod("POST").setBody(bodyWritable).execute();
    }

    @Override
    public CompletionStage<? extends StandaloneWSResponse> put(BodyWritable bodyWritable) {
        return this.setMethod("PUT").setBody(bodyWritable).execute();
    }

    @Override
    public CompletionStage<? extends StandaloneWSResponse> delete() {
        return this.setMethod("DELETE").execute();
    }

    @Override
    public CompletionStage<? extends StandaloneWSResponse> head() {
        return this.setMethod("HEAD").execute();
    }

    @Override
    public CompletionStage<? extends StandaloneWSResponse> options() {
        return this.setMethod("OPTIONS").execute();
    }

    @Override
    public CompletionStage<? extends StandaloneWSResponse> execute(String string2) {
        return this.setMethod(string2).execute();
    }

    @Override
    public CompletionStage<? extends StandaloneWSResponse> execute() {
        WSRequestExecutor wSRequestExecutor = this.foldRight(standaloneWSRequest -> {
            StandaloneAhcWSRequest standaloneAhcWSRequest = (StandaloneAhcWSRequest)standaloneWSRequest;
            Request request2 = standaloneAhcWSRequest.buildRequest();
            return this.client.execute(request2);
        }, this.filters.iterator());
        return (CompletionStage)wSRequestExecutor.apply(this);
    }

    @Override
    public CompletionStage<? extends StandaloneWSResponse> stream() {
        WSRequestExecutor wSRequestExecutor = this.foldRight(standaloneWSRequest -> {
            StandaloneAhcWSRequest standaloneAhcWSRequest = (StandaloneAhcWSRequest)standaloneWSRequest;
            Request request2 = standaloneAhcWSRequest.buildRequest();
            return this.client.executeStream(request2, this.materializer.executionContext());
        }, this.filters.iterator());
        return (CompletionStage)wSRequestExecutor.apply(this);
    }

    private WSRequestExecutor foldRight(WSRequestExecutor wSRequestExecutor, Iterator<WSRequestFilter> iterator2) {
        if (!iterator2.hasNext()) {
            return wSRequestExecutor;
        }
        WSRequestFilter wSRequestFilter = iterator2.next();
        return this.foldRight((WSRequestExecutor)wSRequestFilter.apply(wSRequestExecutor), iterator2);
    }

    Request buildRequest() {
        DefaultHttpHeaders defaultHttpHeaders = new DefaultHttpHeaders(true);
        this.headers.forEach(defaultHttpHeaders::add);
        RequestBuilder requestBuilder = new RequestBuilder(this.method);
        requestBuilder.setUrl(this.url);
        requestBuilder.setQueryParams(this.queryParameters);
        this.getBody().ifPresent(bodyWritable -> {
            String string3 = defaultHttpHeaders.get("Content-Type");
            if (string3 == null) {
                string3 = bodyWritable.contentType();
            }
            defaultHttpHeaders.set("Content-Type", (Iterable<?>)Collections.singletonList(string3));
            if (bodyWritable instanceof InMemoryBodyWritable) {
                ByteString byteString2 = (ByteString)((InMemoryBodyWritable)bodyWritable).body().get();
                if (string3.equals("application/json")) {
                    requestBuilder.setBody(byteString2.toArray());
                } else {
                    Charset charset = HttpUtils.extractContentTypeCharsetAttribute(string3);
                    if (charset == null) {
                        charset = StandardCharsets.UTF_8;
                    }
                    requestBuilder.setCharset(charset);
                    String string4 = byteString2.decodeString(charset);
                    if (string3.equals("application/x-www-form-urlencoded")) {
                        defaultHttpHeaders.remove("Content-Length");
                        Map<String, List<String>> map2 = FormUrlEncodedParser.parseAsJava(string4, "utf-8");
                        map2.forEach((string2, list2) -> list2.forEach(string3 -> {
                            RequestBuilder cfr_ignored_0 = (RequestBuilder)requestBuilder.addFormParam((String)string2, (String)string3);
                        }));
                    } else {
                        requestBuilder.setBody(string4);
                    }
                }
            } else if (bodyWritable instanceof SourceBodyWritable) {
                long l = Optional.ofNullable(defaultHttpHeaders.get("Content-Length")).map(Long::valueOf).orElse(-1L);
                defaultHttpHeaders.remove("Content-Length");
                Source source2 = (Source)((SourceBodyWritable)bodyWritable).body().get();
                Publisher<ByteBuf> publisher = source2.map(byteString -> Unpooled.wrappedBuffer(byteString.toByteBuffer())).runWith(Sink.asPublisher(AsPublisher.WITHOUT_FANOUT), this.materializer);
                requestBuilder.setBody(publisher, l);
            } else {
                throw new IllegalStateException("Unknown body writable: " + bodyWritable);
            }
        });
        requestBuilder.setHeaders(defaultHttpHeaders);
        if (this.timeout.isNegative()) {
            requestBuilder.setRequestTimeout((int)INFINITE.toMillis());
        } else if (this.timeout.compareTo(Duration.ZERO) > 0) {
            requestBuilder.setRequestTimeout((int)this.timeout.toMillis());
        }
        this.getFollowRedirects().ifPresent(requestBuilder::setFollowRedirect);
        this.getVirtualHost().ifPresent(requestBuilder::setVirtualHost);
        this.getAuth().ifPresent(wSAuthInfo -> {
            RequestBuilder cfr_ignored_0 = (RequestBuilder)requestBuilder.setRealm(StandaloneAhcWSRequest.auth(wSAuthInfo.getUsername(), wSAuthInfo.getPassword(), wSAuthInfo.getScheme()));
        });
        if (this.calculator != null) {
            if (this.calculator instanceof OAuth.OAuthCalculator) {
                OAuthSignatureCalculator oAuthSignatureCalculator = ((OAuth.OAuthCalculator)this.calculator).getCalculator();
                requestBuilder.setSignatureCalculator(oAuthSignatureCalculator);
            } else if (this.calculator instanceof SignatureCalculator) {
                SignatureCalculator signatureCalculator = (SignatureCalculator)((Object)this.calculator);
                requestBuilder.setSignatureCalculator(signatureCalculator);
            } else {
                throw new IllegalStateException("Use OAuth.OAuthCalculator");
            }
        }
        this.cookies.forEach(wSCookie -> {
            DefaultCookie defaultCookie = new DefaultCookie(wSCookie.getName(), wSCookie.getValue());
            defaultCookie.setWrap(false);
            defaultCookie.setDomain(wSCookie.getDomain().orElse(null));
            defaultCookie.setPath(wSCookie.getPath().orElse(null));
            defaultCookie.setMaxAge(wSCookie.getMaxAge().orElse(-1L));
            defaultCookie.setSecure(wSCookie.isSecure());
            defaultCookie.setHttpOnly(wSCookie.isHttpOnly());
            requestBuilder.addCookie(defaultCookie);
        });
        return requestBuilder.build();
    }

    private static void addValueTo(Map<String, List<String>> map2, String string2, String string3) {
        if (map2.containsKey(string2)) {
            List<String> list2 = map2.get(string2);
            list2.add(string3);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string3);
            map2.put(string2, arrayList);
        }
    }

    static Realm auth(String string2, String string3, WSAuthScheme wSAuthScheme) {
        Realm.AuthScheme authScheme = Realm.AuthScheme.valueOf(wSAuthScheme.name());
        Boolean bl = wSAuthScheme != WSAuthScheme.DIGEST;
        return new Realm.Builder(string2, string3).setScheme(authScheme).setUsePreemptiveAuth(bl).build();
    }
}

