/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import akka.Done;
import akka.stream.Materializer;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import akka.util.ByteStringBuilder;
import com.typesafe.sslconfig.ssl.SystemConfiguration;
import com.typesafe.sslconfig.ssl.debug.DebugConfiguration;
import java.io.IOException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.inject.Inject;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.ahc.AhcConfigBuilder;
import play.api.libs.ws.ahc.AhcLoggerFactory;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.api.libs.ws.ahc.DefaultStreamedAsyncHandler;
import play.api.libs.ws.ahc.StreamedState;
import play.api.libs.ws.ahc.cache.AhcHttpCache;
import play.api.libs.ws.ahc.cache.CachingAsyncHttpClient;
import play.libs.ws.StandaloneWSClient;
import play.libs.ws.StandaloneWSResponse;
import play.libs.ws.ahc.StandaloneAhcWSRequest;
import play.libs.ws.ahc.StandaloneAhcWSResponse;
import play.libs.ws.ahc.StreamedResponse;
import play.shaded.ahc.org.asynchttpclient.AsyncCompletionHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.Response;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

public class StandaloneAhcWSClient
implements StandaloneWSClient {
    private final AsyncHttpClient asyncHttpClient;
    private final Materializer materializer;

    @Inject
    public StandaloneAhcWSClient(AsyncHttpClient asyncHttpClient, Materializer materializer) {
        this.asyncHttpClient = asyncHttpClient;
        this.materializer = materializer;
    }

    @Override
    public Object getUnderlying() {
        return this.asyncHttpClient;
    }

    @Override
    public StandaloneAhcWSRequest url(String string2) {
        return new StandaloneAhcWSRequest(this, string2, this.materializer);
    }

    @Override
    public void close() throws IOException {
        this.asyncHttpClient.close();
    }

    CompletionStage<StandaloneWSResponse> execute(Request request2) {
        Promise<StandaloneWSResponse> promise = Promise$.MODULE$.apply();
        ResponseAsyncCompletionHandler responseAsyncCompletionHandler = new ResponseAsyncCompletionHandler(promise);
        try {
            this.asyncHttpClient.executeRequest(request2, responseAsyncCompletionHandler);
        }
        catch (RuntimeException runtimeException) {
            promise.failure(runtimeException);
        }
        Future<StandaloneWSResponse> future2 = promise.future();
        return FutureConverters.toJava(future2);
    }

    CompletionStage<StandaloneWSResponse> executeStream(Request request2, ExecutionContext executionContext) {
        Promise promise = Promise$.MODULE$.apply();
        final Promise<Done> promise2 = Promise$.MODULE$.apply();
        Function<StreamedState, StandaloneWSResponse> function2 = streamedState -> {
            final Publisher<HttpResponseBodyPart> publisher = streamedState.publisher();
            Publisher<HttpResponseBodyPart> publisher2 = new Publisher<HttpResponseBodyPart>(){

                @Override
                public void subscribe(final Subscriber<? super HttpResponseBodyPart> subscriber) {
                    publisher.subscribe(new Subscriber<HttpResponseBodyPart>(){

                        @Override
                        public void onSubscribe(Subscription subscription) {
                            subscriber.onSubscribe(subscription);
                        }

                        @Override
                        public void onNext(HttpResponseBodyPart httpResponseBodyPart) {
                            subscriber.onNext(httpResponseBodyPart);
                        }

                        @Override
                        public void onError(Throwable throwable2) {
                            subscriber.onError(throwable2);
                        }

                        @Override
                        public void onComplete() {
                            FutureConverters$.MODULE$.toJava(promise2.future()).handle((done, throwable2) -> {
                                if (done != null) {
                                    subscriber.onComplete();
                                } else {
                                    subscriber.onError((Throwable)throwable2);
                                }
                                return null;
                            });
                        }
                    });
                }
            };
            return new StreamedResponse(this, streamedState.statusCode(), streamedState.statusText(), streamedState.uriOption().get(), streamedState.responseHeaders(), publisher2, this.asyncHttpClient.getConfig().isUseLaxCookieEncoder());
        };
        this.asyncHttpClient.executeRequest(request2, new DefaultStreamedAsyncHandler<StandaloneWSResponse>(function2, promise, promise2));
        return FutureConverters.toJava(promise.future());
    }

    public static StandaloneAhcWSClient create(AhcWSClientConfig ahcWSClientConfig, Materializer materializer) {
        return StandaloneAhcWSClient.create(ahcWSClientConfig, null, materializer);
    }

    public static StandaloneAhcWSClient create(AhcWSClientConfig ahcWSClientConfig, AhcHttpCache ahcHttpCache, Materializer materializer) {
        AhcLoggerFactory ahcLoggerFactory = new AhcLoggerFactory(LoggerFactory.getILoggerFactory());
        if (ahcWSClientConfig.wsClientConfig().ssl().debug().enabled()) {
            new DebugConfiguration(ahcLoggerFactory).configure(ahcWSClientConfig.wsClientConfig().ssl().debug());
        }
        AhcConfigBuilder ahcConfigBuilder = new AhcConfigBuilder(ahcWSClientConfig);
        DefaultAsyncHttpClientConfig.Builder builder = ahcConfigBuilder.configure();
        new SystemConfiguration(ahcLoggerFactory).configure(ahcWSClientConfig.wsClientConfig().ssl());
        DefaultAsyncHttpClientConfig defaultAsyncHttpClientConfig = builder.build();
        DefaultAsyncHttpClient defaultAsyncHttpClient = new DefaultAsyncHttpClient(defaultAsyncHttpClientConfig);
        AsyncHttpClient asyncHttpClient = ahcHttpCache != null ? new CachingAsyncHttpClient(defaultAsyncHttpClient, ahcHttpCache) : defaultAsyncHttpClient;
        return new StandaloneAhcWSClient(asyncHttpClient, materializer);
    }

    ByteString blockingToByteString(Source<ByteString, ?> source2) {
        try {
            return source2.runFold(ByteString.createBuilder(), ByteStringBuilder::append, this.materializer).thenApply(ByteStringBuilder::result).toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class ResponseAsyncCompletionHandler
    extends AsyncCompletionHandler<Response> {
        private final Promise<StandaloneWSResponse> scalaPromise;

        public ResponseAsyncCompletionHandler(Promise<StandaloneWSResponse> promise) {
            this.scalaPromise = promise;
        }

        @Override
        public Response onCompleted(Response response) {
            StandaloneAhcWSResponse standaloneAhcWSResponse = new StandaloneAhcWSResponse(response);
            this.scalaPromise.success(standaloneAhcWSResponse);
            return response;
        }

        @Override
        public void onThrowable(Throwable throwable2) {
            this.scalaPromise.failure(throwable2);
        }
    }
}

