/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import play.libs.ws.WSCookie;
import play.libs.ws.WSCookieBuilder;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;

interface CookieBuilder {
    default public List<WSCookie> buildCookies(Map<String, List<String>> map2) {
        List<String> list2 = map2.get(HttpHeaderNames.SET_COOKIE2);
        if (!MiscUtils.isNonEmpty(list2)) {
            list2 = map2.get(HttpHeaderNames.SET_COOKIE);
        }
        if (MiscUtils.isNonEmpty(list2)) {
            ArrayList<WSCookie> arrayList = new ArrayList<WSCookie>(list2.size());
            for (String string2 : list2) {
                Cookie cookie2 = this.isUseLaxCookieEncoder() ? ClientCookieDecoder.LAX.decode(string2) : ClientCookieDecoder.STRICT.decode(string2);
                if (cookie2 == null) continue;
                WSCookie wSCookie = new WSCookieBuilder().setName(cookie2.name()).setValue(cookie2.value()).setDomain(cookie2.domain()).setPath(cookie2.path()).setMaxAge(cookie2.maxAge()).setSecure(cookie2.isSecure()).setHttpOnly(cookie2.isHttpOnly()).build();
                arrayList.add(wSCookie);
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    public boolean isUseLaxCookieEncoder();
}

