/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import play.libs.ws.BodyWritable;
import play.libs.ws.StandaloneWSResponse;
import play.libs.ws.WSAuthInfo;
import play.libs.ws.WSAuthScheme;
import play.libs.ws.WSCookie;
import play.libs.ws.WSRequestFilter;
import play.libs.ws.WSSignatureCalculator;

public interface StandaloneWSRequest {
    public CompletionStage<? extends StandaloneWSResponse> get();

    public CompletionStage<? extends StandaloneWSResponse> patch(BodyWritable var1);

    public CompletionStage<? extends StandaloneWSResponse> post(BodyWritable var1);

    public CompletionStage<? extends StandaloneWSResponse> put(BodyWritable var1);

    public CompletionStage<? extends StandaloneWSResponse> delete();

    public CompletionStage<? extends StandaloneWSResponse> head();

    public CompletionStage<? extends StandaloneWSResponse> options();

    public CompletionStage<? extends StandaloneWSResponse> execute(String var1);

    public CompletionStage<? extends StandaloneWSResponse> execute();

    public CompletionStage<? extends StandaloneWSResponse> stream();

    public StandaloneWSRequest setUrl(String var1);

    public StandaloneWSRequest setMethod(String var1);

    public StandaloneWSRequest setBody(BodyWritable var1);

    public StandaloneWSRequest setHeaders(Map<String, List<String>> var1);

    public StandaloneWSRequest addHeader(String var1, String var2);

    public StandaloneWSRequest setQueryString(String var1);

    public StandaloneWSRequest addQueryParameter(String var1, String var2);

    public StandaloneWSRequest setQueryString(Map<String, List<String>> var1);

    public StandaloneWSRequest addCookie(WSCookie var1);

    public StandaloneWSRequest addCookies(WSCookie ... var1);

    public StandaloneWSRequest setCookies(List<WSCookie> var1);

    public StandaloneWSRequest setAuth(String var1);

    default public StandaloneWSRequest setAuth(String string2, String string3) {
        return this.setAuth(new WSAuthInfo(string2, string3, WSAuthScheme.BASIC));
    }

    default public StandaloneWSRequest setAuth(String string2, String string3, WSAuthScheme wSAuthScheme) {
        return this.setAuth(new WSAuthInfo(string2, string3, wSAuthScheme));
    }

    public StandaloneWSRequest setAuth(WSAuthInfo var1);

    public StandaloneWSRequest sign(WSSignatureCalculator var1);

    public StandaloneWSRequest setFollowRedirects(boolean var1);

    public StandaloneWSRequest setVirtualHost(String var1);

    public StandaloneWSRequest setRequestTimeout(Duration var1);

    public StandaloneWSRequest setRequestFilter(WSRequestFilter var1);

    public StandaloneWSRequest setContentType(String var1);

    public String getUrl();

    default public String getMethod() {
        throw new UnsupportedOperationException();
    }

    default public List<WSCookie> getCookies() {
        throw new UnsupportedOperationException();
    }

    public Optional<BodyWritable> getBody();

    public Map<String, List<String>> getHeaders();

    public List<String> getHeaderValues(String var1);

    public Optional<String> getHeader(String var1);

    public Map<String, List<String>> getQueryParameters();

    default public Optional<String> getUsername() {
        return this.getAuth().map(WSAuthInfo::getUsername);
    }

    default public Optional<String> getPassword() {
        return this.getAuth().map(WSAuthInfo::getPassword);
    }

    default public Optional<WSAuthScheme> getScheme() {
        return this.getAuth().map(WSAuthInfo::getScheme);
    }

    public Optional<WSAuthInfo> getAuth();

    public Optional<WSSignatureCalculator> getCalculator();

    public Optional<Duration> getRequestTimeout();

    public Optional<Boolean> getFollowRedirects();

    public Optional<String> getContentType();
}

