/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws;

import akka.stream.javadsl.FileIO;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import play.libs.ws.BodyWritable;
import play.libs.ws.InMemoryBodyWritable;
import play.libs.ws.SourceBodyWritable;

public interface DefaultBodyWritables {
    default public BodyWritable<ByteString> body(String string2) {
        return this.body(string2, "text/plain");
    }

    default public BodyWritable<ByteString> body(String string2, String string3) {
        return new InMemoryBodyWritable(ByteString.fromString(string2), string3);
    }

    default public BodyWritable<ByteString> body(byte[] byArray) {
        return this.body(byArray, "application/octet-stream");
    }

    default public BodyWritable<ByteString> body(byte[] byArray, String string2) {
        return new InMemoryBodyWritable(ByteString.fromArray(byArray), string2);
    }

    default public BodyWritable<ByteString> body(ByteBuffer byteBuffer) {
        return this.body(byteBuffer, "application/octet-stream");
    }

    default public BodyWritable<ByteString> body(ByteBuffer byteBuffer, String string2) {
        return new InMemoryBodyWritable(ByteString.fromByteBuffer(byteBuffer), string2);
    }

    default public BodyWritable<Source<ByteString, ?>> body(Source<ByteString, ?> source2) {
        return new SourceBodyWritable(source2);
    }

    default public BodyWritable<Source<ByteString, ?>> body(File file) {
        return new SourceBodyWritable(FileIO.fromFile(file));
    }

    default public BodyWritable<ByteString> body(Map<String, String> map2) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>(map2.size());
            for (Map.Entry<String, String> object2 : map2.entrySet()) {
                String string2 = URLEncoder.encode(object2.getKey(), "UTF-8");
                String string3 = URLEncoder.encode(object2.getValue(), "UTF-8");
                arrayList.add(string2 + '=' + string3);
            }
            String string4 = String.join((CharSequence)"&", arrayList);
            ByteString byteString = ByteString.fromString(string4);
            return new InMemoryBodyWritable(byteString, "application/x-www-form-urlencoded");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    default public BodyWritable<Source<ByteString, ?>> body(Supplier<InputStream> supplier) {
        return new SourceBodyWritable(StreamConverters.fromInputStream(supplier::get));
    }
}

