/*
 * Decompiled with CFR 0.152.
 */
package play.libs.oauth;

import play.libs.ws.WSSignatureCalculator;
import play.shaded.ahc.org.asynchttpclient.oauth.OAuthSignatureCalculator;
import play.shaded.oauth.oauth.signpost.OAuthProvider;
import play.shaded.oauth.oauth.signpost.basic.DefaultOAuthConsumer;
import play.shaded.oauth.oauth.signpost.basic.DefaultOAuthProvider;
import play.shaded.oauth.oauth.signpost.exception.OAuthException;

public class OAuth {
    private ServiceInfo info;
    private OAuthProvider provider;

    public OAuth(ServiceInfo serviceInfo) {
        this(serviceInfo, true);
    }

    public OAuth(ServiceInfo serviceInfo, boolean bl) {
        this.info = serviceInfo;
        this.provider = new DefaultOAuthProvider(serviceInfo.requestTokenURL, serviceInfo.accessTokenURL, serviceInfo.authorizationURL);
        this.provider.setOAuth10a(bl);
    }

    public ServiceInfo getInfo() {
        return this.info;
    }

    public OAuthProvider getProvider() {
        return this.provider;
    }

    public RequestToken retrieveRequestToken(String string2) {
        DefaultOAuthConsumer defaultOAuthConsumer = new DefaultOAuthConsumer(this.info.key.key, this.info.key.secret);
        try {
            this.provider.retrieveRequestToken(defaultOAuthConsumer, string2, new String[0]);
            return new RequestToken(defaultOAuthConsumer.getToken(), defaultOAuthConsumer.getTokenSecret());
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException(oAuthException);
        }
    }

    public RequestToken retrieveAccessToken(RequestToken requestToken, String string2) {
        DefaultOAuthConsumer defaultOAuthConsumer = new DefaultOAuthConsumer(this.info.key.key, this.info.key.secret);
        defaultOAuthConsumer.setTokenWithSecret(requestToken.token, requestToken.secret);
        try {
            this.provider.retrieveAccessToken(defaultOAuthConsumer, string2, new String[0]);
            return new RequestToken(defaultOAuthConsumer.getToken(), defaultOAuthConsumer.getTokenSecret());
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException(oAuthException);
        }
    }

    public String redirectUrl(String string2) {
        return play.shaded.oauth.oauth.signpost.OAuth.addQueryParameters(this.provider.getAuthorizationWebsiteUrl(), "oauth_token", string2);
    }

    public static class OAuthCalculator
    implements WSSignatureCalculator {
        private OAuthSignatureCalculator calculator;

        public OAuthCalculator(ConsumerKey consumerKey, RequestToken requestToken) {
            play.shaded.ahc.org.asynchttpclient.oauth.ConsumerKey consumerKey2 = new play.shaded.ahc.org.asynchttpclient.oauth.ConsumerKey(consumerKey.key, consumerKey.secret);
            play.shaded.ahc.org.asynchttpclient.oauth.RequestToken requestToken2 = new play.shaded.ahc.org.asynchttpclient.oauth.RequestToken(requestToken.token, requestToken.secret);
            this.calculator = new OAuthSignatureCalculator(consumerKey2, requestToken2);
        }

        public OAuthSignatureCalculator getCalculator() {
            return this.calculator;
        }
    }

    public static class ServiceInfo {
        public String requestTokenURL;
        public String accessTokenURL;
        public String authorizationURL;
        public ConsumerKey key;

        public ServiceInfo(String string2, String string3, String string4, ConsumerKey consumerKey) {
            this.requestTokenURL = string2;
            this.accessTokenURL = string3;
            this.authorizationURL = string4;
            this.key = consumerKey;
        }
    }

    public static class RequestToken {
        public String token;
        public String secret;

        public RequestToken(String string2, String string3) {
            this.token = string2;
            this.secret = string3;
        }
    }

    public static class ConsumerKey {
        public String key;
        public String secret;

        public ConsumerKey(String string2, String string3) {
            this.key = string2;
            this.secret = string3;
        }
    }
}

