/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;

@Singleton
@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u001b\t9\u0012\t[2X'\u000ec\u0017.\u001a8u\u0007>tg-[4QCJ\u001cXM\u001d\u0006\u0003\u0007\u0011\t1!\u00195d\u0015\t)a!\u0001\u0002xg*\u0011q\u0001C\u0001\u0005Y&\u00147O\u0003\u0002\n\u0015\u0005\u0019\u0011\r]5\u000b\u0003-\tA\u0001\u001d7bs\u000e\u00011c\u0001\u0001\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000fE\u0002\u00189yi\u0011\u0001\u0007\u0006\u00033i\ta!\u001b8kK\u000e$(\"A\u000e\u0002\u000b)\fg/\u0019=\n\u0005uA\"\u0001\u0003)s_ZLG-\u001a:\u0011\u0005}\u0001S\"\u0001\u0002\n\u0005\u0005\u0012!!E!iG^\u001b6\t\\5f]R\u001cuN\u001c4jO\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\bxg\u000ec\u0017.\u001a8u\u0007>tg-[4\u0011\u0005\u00152S\"\u0001\u0003\n\u0005\u001d\"!AD,T\u00072LWM\u001c;D_:4\u0017n\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"a\u000b\u001a\u000e\u00031R!!\f\u0018\u0002\r\r|gNZ5h\u0015\ty\u0003'\u0001\u0005usB,7/\u00194f\u0015\u0005\t\u0014aA2p[&\u00111\u0007\f\u0002\u0007\u0007>tg-[4\t\u0011U\u0002!\u0011!Q\u0001\nY\n1b\u00197bgNdu.\u00193feB\u0011qbN\u0005\u0003qA\u00111b\u00117bgNdu.\u00193fe\")!\b\u0001C\u0001w\u00051A(\u001b8jiz\"B\u0001P\u001f?\u007fA\u0011q\u0004\u0001\u0005\u0006Ge\u0002\r\u0001\n\u0005\u0006Se\u0002\rA\u000b\u0005\u0006ke\u0002\rA\u000e\u0015\u0003s\u0005\u0003\"a\u0006\"\n\u0005\rC\"AB%oU\u0016\u001cG\u000fC\u0003F\u0001\u0011\u0005a)A\u0002hKR$\u0012A\b\u0005\u0006\u0011\u0002!\tAR\u0001\u0006a\u0006\u00148/\u001a\u0015\u0003\u0001)\u0003\"aF&\n\u00051C\"!C*j]\u001edW\r^8o\u0001")
public class AhcWSClientConfigParser
implements Provider<AhcWSClientConfig> {
    private final WSClientConfig wsClientConfig;
    private final Config configuration;

    @Override
    public AhcWSClientConfig get() {
        return this.parse();
    }

    public AhcWSClientConfig parse() {
        int maximumConnectionsPerHost = this.configuration.getInt("play.ws.ahc.maxConnectionsPerHost");
        int maximumConnectionsTotal = this.configuration.getInt("play.ws.ahc.maxConnectionsTotal");
        Duration maxConnectionLifetime = this.getDuration$1("play.ws.ahc.maxConnectionLifetime", Duration$.MODULE$.Inf());
        Duration idleConnectionInPoolTimeout = this.getDuration$1("play.ws.ahc.idleConnectionInPoolTimeout", new package.DurationInt(package$.MODULE$.DurationInt(1)).minute());
        int maximumNumberOfRedirects = this.configuration.getInt("play.ws.ahc.maxNumberOfRedirects");
        int maxRequestRetry = this.configuration.getInt("play.ws.ahc.maxRequestRetry");
        boolean disableUrlEncoding = this.configuration.getBoolean("play.ws.ahc.disableUrlEncoding");
        boolean keepAlive2 = this.configuration.getBoolean("play.ws.ahc.keepAlive");
        boolean useLaxCookieEncoder = this.configuration.getBoolean("play.ws.ahc.useLaxCookieEncoder");
        boolean useCookieStore = this.configuration.getBoolean("play.ws.ahc.useCookieStore");
        return new AhcWSClientConfig(this.wsClientConfig, maximumConnectionsPerHost, maximumConnectionsTotal, maxConnectionLifetime, idleConnectionInPoolTimeout, maximumNumberOfRedirects, maxRequestRetry, disableUrlEncoding, keepAlive2, useLaxCookieEncoder, useCookieStore);
    }

    private final Duration getDuration$1(String key, Duration duration) {
        Duration duration2;
        try {
            duration2 = Duration$.MODULE$.apply(this.configuration.getString(key));
        }
        catch (ConfigException.Null nullVal) {
            duration2 = duration;
        }
        return duration2;
    }

    @Inject
    public AhcWSClientConfigParser(WSClientConfig wsClientConfig, Config configuration, ClassLoader classLoader) {
        this.wsClientConfig = wsClientConfig;
        this.configuration = configuration;
    }
}

