/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.sslconfig.ssl.SSLConfigParser;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.util.EnrichedConfig$;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.libs.ws.WSClientConfig;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u0017\tqqkU\"p]\u001aLw\rU1sg\u0016\u0014(BA\u0002\u0005\u0003\t98O\u0003\u0002\u0006\r\u0005!A.\u001b2t\u0015\t9\u0001\"A\u0002ba&T\u0011!C\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u0001aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\r)\"\u0004H\u0007\u0002-)\u0011q\u0003G\u0001\u0007S:TWm\u0019;\u000b\u0003e\tQA[1wCbL!a\u0007\f\u0003\u0011A\u0013xN^5eKJ\u0004\"!\b\u0010\u000e\u0003\tI!a\b\u0002\u0003\u001d]\u001b6\t\\5f]R\u001cuN\u001c4jO\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0004d_:4\u0017n\u001a\t\u0003G%j\u0011\u0001\n\u0006\u0003C\u0015R!AJ\u0014\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001K\u0001\u0004G>l\u0017B\u0001\u0016%\u0005\u0019\u0019uN\u001c4jO\"AA\u0006\u0001B\u0001B\u0003%Q&A\u0006dY\u0006\u001c8\u000fT8bI\u0016\u0014\bCA\u0007/\u0013\tycBA\u0006DY\u0006\u001c8\u000fT8bI\u0016\u0014\b\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\bF\u00024iU\u0002\"!\b\u0001\t\u000b\u0005\u0002\u0004\u0019\u0001\u0012\t\u000b1\u0002\u0004\u0019A\u0017)\u0005A:\u0004CA\u000b9\u0013\tIdC\u0001\u0004J]*,7\r\u001e\u0005\u0006w\u0001!\t\u0001P\u0001\u0006a\u0006\u00148/\u001a\u000b\u00029!Aa\b\u0001EC\u0002\u0013\u0005s(A\u0002hKR,\u0012\u0001\b\u0005\t\u0003\u0002A\t\u0011)Q\u00059\u0005!q-\u001a;!Q\t\u00011\t\u0005\u0002\u0016\t&\u0011QI\u0006\u0002\n'&tw\r\\3u_:\u0004")
public class WSConfigParser
implements Provider<WSClientConfig> {
    private final Config config;
    private final ClassLoader classLoader;
    private WSClientConfig get;
    private volatile boolean bitmap$0;

    private WSClientConfig get$lzycompute() {
        WSConfigParser wSConfigParser = this;
        synchronized (wSConfigParser) {
            if (!this.bitmap$0) {
                this.get = this.parse();
                this.bitmap$0 = true;
            }
            return this.get;
        }
    }

    public WSClientConfig parse() {
        Option option2;
        Config wsConfig = this.config.getConfig("play.ws");
        Duration connectionTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.connection"));
        Duration idleTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.idle"));
        Duration requestTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.request"));
        boolean followRedirects2 = wsConfig.getBoolean("followRedirects");
        boolean useProxyProperties = wsConfig.getBoolean("useProxyProperties");
        try {
            option2 = new Some<String>(wsConfig.getString("useragent"));
        }
        catch (ConfigException.Null nullVal) {
            option2 = None$.MODULE$;
        }
        Option userAgent = option2;
        boolean compressionEnabled = wsConfig.getBoolean("compressionEnabled");
        SSLConfigSettings sslConfig = new SSLConfigParser(EnrichedConfig$.MODULE$.apply(wsConfig.getConfig("ssl")), this.classLoader).parse();
        return new WSClientConfig(connectionTimeout, idleTimeout, requestTimeout, followRedirects2, useProxyProperties, userAgent, compressionEnabled, sslConfig);
    }

    @Override
    public WSClientConfig get() {
        return this.bitmap$0 ? this.get : this.get$lzycompute();
    }

    @Inject
    public WSConfigParser(Config config, ClassLoader classLoader) {
        this.config = config;
        this.classLoader = classLoader;
    }
}

