/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import java.util.regex.Pattern;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

public final class NumericArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new NumericArrayStringConverterFactory();
    static final Pattern DELIMITER = Pattern.compile("[,]");

    private NumericArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls.isArray() && cls.getComponentType().isPrimitive()) {
            if (cls == long[].class) {
                return LongArrayStringConverter.INSTANCE;
            }
            if (cls == int[].class) {
                return IntArrayStringConverter.INSTANCE;
            }
            if (cls == short[].class) {
                return ShortArrayStringConverter.INSTANCE;
            }
            if (cls == double[].class) {
                return DoubleArrayStringConverter.INSTANCE;
            }
            if (cls == float[].class) {
                return FloatArrayStringConverter.INSTANCE;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum FloatArrayStringConverter implements TypedStringConverter<float[]>
    {
        INSTANCE{

            @Override
            public String convertToString(float[] array2) {
                if (array2.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array2.length * 8);
                buf.append(array2[0]);
                for (int i = 1; i < array2.length; ++i) {
                    buf.append(',').append(array2[i]);
                }
                return buf.toString();
            }

            @Override
            public float[] convertFromString(Class<? extends float[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                String[] split2 = DELIMITER.split(str);
                float[] array2 = new float[split2.length];
                for (int i = 0; i < split2.length; ++i) {
                    array2[i] = Float.parseFloat(split2[i]);
                }
                return array2;
            }

            @Override
            public Class<?> getEffectiveType() {
                return float[].class;
            }
        };

        private static final float[] EMPTY;

        static {
            EMPTY = new float[0];
        }
    }

    static enum DoubleArrayStringConverter implements TypedStringConverter<double[]>
    {
        INSTANCE{

            @Override
            public String convertToString(double[] array2) {
                if (array2.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array2.length * 8);
                buf.append(array2[0]);
                for (int i = 1; i < array2.length; ++i) {
                    buf.append(',').append(array2[i]);
                }
                return buf.toString();
            }

            @Override
            public double[] convertFromString(Class<? extends double[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                String[] split2 = DELIMITER.split(str);
                double[] array2 = new double[split2.length];
                for (int i = 0; i < split2.length; ++i) {
                    array2[i] = Double.parseDouble(split2[i]);
                }
                return array2;
            }

            @Override
            public Class<?> getEffectiveType() {
                return double[].class;
            }
        };

        private static final double[] EMPTY;

        static {
            EMPTY = new double[0];
        }
    }

    static enum ShortArrayStringConverter implements TypedStringConverter<short[]>
    {
        INSTANCE{

            @Override
            public String convertToString(short[] array2) {
                if (array2.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array2.length * 3);
                buf.append(array2[0]);
                for (int i = 1; i < array2.length; ++i) {
                    buf.append(',').append(array2[i]);
                }
                return buf.toString();
            }

            @Override
            public short[] convertFromString(Class<? extends short[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                String[] split2 = DELIMITER.split(str);
                short[] array2 = new short[split2.length];
                for (int i = 0; i < split2.length; ++i) {
                    array2[i] = Short.parseShort(split2[i]);
                }
                return array2;
            }

            @Override
            public Class<?> getEffectiveType() {
                return short[].class;
            }
        };

        private static final short[] EMPTY;

        static {
            EMPTY = new short[0];
        }
    }

    static enum IntArrayStringConverter implements TypedStringConverter<int[]>
    {
        INSTANCE{

            @Override
            public String convertToString(int[] array2) {
                if (array2.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array2.length * 6);
                buf.append(array2[0]);
                for (int i = 1; i < array2.length; ++i) {
                    buf.append(',').append(array2[i]);
                }
                return buf.toString();
            }

            @Override
            public int[] convertFromString(Class<? extends int[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                String[] split2 = DELIMITER.split(str);
                int[] array2 = new int[split2.length];
                for (int i = 0; i < split2.length; ++i) {
                    array2[i] = Integer.parseInt(split2[i]);
                }
                return array2;
            }

            @Override
            public Class<?> getEffectiveType() {
                return int[].class;
            }
        };

        private static final int[] EMPTY;

        static {
            EMPTY = new int[0];
        }
    }

    static enum LongArrayStringConverter implements TypedStringConverter<long[]>
    {
        INSTANCE{

            @Override
            public String convertToString(long[] array2) {
                if (array2.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array2.length * 8);
                buf.append(array2[0]);
                for (int i = 1; i < array2.length; ++i) {
                    buf.append(',').append(array2[i]);
                }
                return buf.toString();
            }

            @Override
            public long[] convertFromString(Class<? extends long[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                String[] split2 = DELIMITER.split(str);
                long[] array2 = new long[split2.length];
                for (int i = 0; i < split2.length; ++i) {
                    array2[i] = Long.parseLong(split2[i]);
                }
                return array2;
            }

            @Override
            public Class<?> getEffectiveType() {
                return long[].class;
            }
        };

        private static final long[] EMPTY;

        static {
            EMPTY = new long[0];
        }
    }
}

