/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

public final class CharObjectArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new CharObjectArrayStringConverterFactory();
    static final Pattern DELIMITER = Pattern.compile("[,]");

    private CharObjectArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls == Character[].class) {
            return CharecterArrayStringConverter.INSTANCE;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum CharecterArrayStringConverter implements TypedStringConverter<Character[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Character[] array2) {
                if (array2.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array2.length * 8);
                for (int i = 0; i < array2.length; ++i) {
                    if (array2[i] == null) {
                        buf.append("\\-");
                        continue;
                    }
                    char ch = array2[i].charValue();
                    if (ch == '\\') {
                        buf.append("\\\\");
                        continue;
                    }
                    buf.append(ch);
                }
                return buf.toString();
            }

            @Override
            public Character[] convertFromString(Class<? extends Character[]> cls, String str) {
                int i;
                int pos;
                if (str.length() == 0) {
                    return EMPTY;
                }
                String adjusted = str;
                Character[] array2 = new Character[adjusted.length()];
                int arrayPos = 0;
                while ((pos = adjusted.indexOf(92)) >= 0) {
                    for (i = 0; i < pos; ++i) {
                        array2[arrayPos++] = Character.valueOf(adjusted.charAt(i));
                    }
                    if (adjusted.charAt(pos + 1) == '\\') {
                        array2[arrayPos++] = Character.valueOf('\\');
                    } else if (adjusted.charAt(pos + 1) == '-') {
                        array2[arrayPos++] = null;
                    } else {
                        throw new IllegalArgumentException("Invalid Character[] string, incorrect escape");
                    }
                    adjusted = adjusted.substring(pos + 2);
                }
                for (i = 0; i < adjusted.length(); ++i) {
                    array2[arrayPos++] = Character.valueOf(adjusted.charAt(i));
                }
                return Arrays.copyOf(array2, arrayPos);
            }

            @Override
            public Class<?> getEffectiveType() {
                return Character[].class;
            }
        };

        private static final Character[] EMPTY;

        static {
            EMPTY = new Character[0];
        }
    }
}

