/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

public final class ByteObjectArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new ByteObjectArrayStringConverterFactory();

    private ByteObjectArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls == Byte[].class) {
            return ByteArrayStringConverter.INSTANCE;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum ByteArrayStringConverter implements TypedStringConverter<Byte[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Byte[] array2) {
                if (array2.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array2.length);
                for (int i = 0; i < array2.length; ++i) {
                    if (array2[i] == null) {
                        buf.append('-').append('-');
                        continue;
                    }
                    byte b2 = array2[i];
                    buf.append(ByteArrayStringConverter.HEX.charAt((b2 & 0xF0) >>> 4)).append(ByteArrayStringConverter.HEX.charAt(b2 & 0xF));
                }
                return buf.toString();
            }

            @Override
            public Byte[] convertFromString(Class<? extends Byte[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                if (str.length() % 2 == 1) {
                    throw new IllegalArgumentException("Invalid Byte[] string");
                }
                Byte[] array2 = new Byte[str.length() / 2];
                for (int i = 0; i < array2.length; ++i) {
                    String in2 = str.substring(i * 2, i * 2 + 2);
                    array2[i] = in2.equals("--") ? null : Byte.valueOf((byte)Integer.parseInt(in2, 16));
                }
                return array2;
            }

            @Override
            public Class<?> getEffectiveType() {
                return Byte[].class;
            }
        };

        private static final Byte[] EMPTY;
        private static final String HEX = "0123456789ABCDEF";

        static {
            EMPTY = new Byte[0];
        }
    }
}

