/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

public final class BooleanObjectArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new BooleanObjectArrayStringConverterFactory();

    private BooleanObjectArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls == Boolean[].class) {
            return BooleanArrayStringConverter.INSTANCE;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum BooleanArrayStringConverter implements TypedStringConverter<Boolean[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Boolean[] array2) {
                if (array2.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array2.length);
                for (int i = 0; i < array2.length; ++i) {
                    buf.append((char)(array2[i] == null ? 45 : (array2[i] != false ? 84 : 70)));
                }
                return buf.toString();
            }

            @Override
            public Boolean[] convertFromString(Class<? extends Boolean[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                Boolean[] array2 = new Boolean[str.length()];
                for (int i = 0; i < array2.length; ++i) {
                    char ch = str.charAt(i);
                    if (ch == 'T') {
                        array2[i] = Boolean.TRUE;
                        continue;
                    }
                    if (ch == 'F') {
                        array2[i] = Boolean.FALSE;
                        continue;
                    }
                    if (ch == '-') {
                        array2[i] = null;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid Boolean[] string, must consist only of 'T', 'F' and '-'");
                }
                return array2;
            }

            @Override
            public Class<?> getEffectiveType() {
                return Boolean[].class;
            }
        };

        private static final Boolean[] EMPTY;

        static {
            EMPTY = new Boolean[0];
        }
    }
}

