/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class RenameHandler {
    public static final RenameHandler INSTANCE = new RenameHandler();
    private volatile boolean locked;
    private final ConcurrentHashMap<String, Class<?>> typeRenames = new ConcurrentHashMap(16, 0.75f, 2);
    private final ConcurrentHashMap<Class<?>, Map<String, Enum<?>>> enumRenames = new ConcurrentHashMap(16, 0.75f, 2);

    public static RenameHandler create() {
        return new RenameHandler();
    }

    private RenameHandler() {
    }

    public void renamedType(String oldName, Class<?> currentValue) {
        if (oldName == null) {
            throw new IllegalArgumentException("oldName must not be null");
        }
        if (currentValue == null) {
            throw new IllegalArgumentException("currentValue must not be null");
        }
        if (oldName.startsWith("java.") || oldName.startsWith("javax.") || oldName.startsWith("org.joda.")) {
            throw new IllegalArgumentException("oldName must not be a java.*, javax.* or org.joda.* type");
        }
        this.checkNotLocked();
        this.typeRenames.put(oldName, currentValue);
    }

    public Map<String, Class<?>> getTypeRenames() {
        return new HashMap(this.typeRenames);
    }

    public Class<?> lookupType(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Class<?> type = this.typeRenames.get(name);
        if (type == null) {
            type = this.loadType(name);
        }
        return type;
    }

    Class<?> loadType(String fullName2) throws ClassNotFoundException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader != null ? loader.loadClass(fullName2) : Class.forName(fullName2);
        }
        catch (ClassNotFoundException ex) {
            return this.loadPrimitiveType(fullName2, ex);
        }
    }

    private Class<?> loadPrimitiveType(String fullName2, ClassNotFoundException ex) throws ClassNotFoundException {
        if (fullName2.equals("int")) {
            return Integer.TYPE;
        }
        if (fullName2.equals("long")) {
            return Long.TYPE;
        }
        if (fullName2.equals("double")) {
            return Double.TYPE;
        }
        if (fullName2.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (fullName2.equals("short")) {
            return Short.TYPE;
        }
        if (fullName2.equals("byte")) {
            return Byte.TYPE;
        }
        if (fullName2.equals("char")) {
            return Character.TYPE;
        }
        if (fullName2.equals("float")) {
            return Float.TYPE;
        }
        if (fullName2.equals("void")) {
            return Void.TYPE;
        }
        throw ex;
    }

    public void renamedEnum(String oldName, Enum<?> currentValue) {
        if (oldName == null) {
            throw new IllegalArgumentException("oldName must not be null");
        }
        if (currentValue == null) {
            throw new IllegalArgumentException("currentValue must not be null");
        }
        this.checkNotLocked();
        Class<?> enumType = currentValue.getDeclaringClass();
        Map<String, Enum<?>> perClass = this.enumRenames.get(enumType);
        if (perClass == null) {
            this.enumRenames.putIfAbsent(enumType, new ConcurrentHashMap(16, 0.75f, 2));
            perClass = this.enumRenames.get(enumType);
        }
        perClass.put(oldName, currentValue);
    }

    public Set<Class<?>> getEnumTypesWithRenames() {
        return new HashSet(this.enumRenames.keySet());
    }

    public Map<String, Enum<?>> getEnumRenames(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        Map<String, Enum<?>> map2 = this.enumRenames.get(type);
        if (map2 == null) {
            return new HashMap();
        }
        return new HashMap(map2);
    }

    public <T extends Enum<T>> T lookupEnum(Class<T> type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Map<String, Enum<?>> map2 = this.getEnumRenames(type);
        Enum<?> value2 = map2.get(name);
        if (value2 != null) {
            return (T)((Enum)type.cast(value2));
        }
        return Enum.valueOf(type, name);
    }

    public void lock() {
        this.checkNotLocked();
        this.locked = true;
    }

    private void checkNotLocked() {
        if (this.locked) {
            throw new IllegalStateException("RenameHandler has been locked and it cannot now be changed");
        }
    }

    public String toString() {
        return "RenamedTypes" + this.typeRenames + ",RenamedEnumConstants" + this.enumRenames;
    }
}

