/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.joda.convert.RenameHandler;

abstract class AbstractTypeStringConverter {
    private static final String EXTENDS = "? extends ";
    private static final String SUPER = "? super ";
    private static final ImmutableMap<String, Class<?>> PRIMITIVES = ImmutableMap.builder().put((Object)"byte", Byte.TYPE).put((Object)"short", Short.TYPE).put((Object)"int", Integer.TYPE).put((Object)"long", Long.TYPE).put((Object)"boolean", Boolean.TYPE).put((Object)"char", Character.TYPE).put((Object)"float", Float.TYPE).put((Object)"double", Double.TYPE).build();
    private static final Method NEW_PARAM_TYPE;
    private static final Method EXTENDS_TYPE;
    private static final Method SUPER_TYPE;

    AbstractTypeStringConverter() {
    }

    static Type parse(String str) {
        try {
            return AbstractTypeStringConverter.doParse(str);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Type doParse(String str) throws Exception {
        Class token2 = (Class)PRIMITIVES.get((Object)str);
        if (token2 != null) {
            return token2;
        }
        int first2 = str.indexOf(60);
        if (first2 < 0) {
            return RenameHandler.INSTANCE.loadType(str);
        }
        int last2 = str.lastIndexOf(62);
        String baseStr = str.substring(0, first2);
        Class<?> base = RenameHandler.INSTANCE.loadType(baseStr);
        String argsStr = str.substring(first2 + 1, last2);
        List<String> splitArgs = AbstractTypeStringConverter.split(argsStr);
        ArrayList types2 = new ArrayList();
        for (String splitArg : splitArgs) {
            Class<?> componentCls;
            String componentStr;
            Class<?> argType;
            String remainder;
            if (splitArg.startsWith(EXTENDS)) {
                remainder = splitArg.substring(EXTENDS.length());
                argType = AbstractTypeStringConverter.wildExtendsType(AbstractTypeStringConverter.doParse(remainder));
            } else if (splitArg.startsWith(SUPER)) {
                remainder = splitArg.substring(SUPER.length());
                argType = AbstractTypeStringConverter.wildSuperType(AbstractTypeStringConverter.doParse(remainder));
            } else if (splitArg.equals("?")) {
                argType = AbstractTypeStringConverter.wildExtendsType(Object.class);
            } else if (splitArg.endsWith("[]")) {
                componentStr = splitArg.substring(0, splitArg.length() - 2);
                componentCls = RenameHandler.INSTANCE.loadType(componentStr);
                argType = Array.newInstance(componentCls, 0).getClass();
            } else if (splitArg.startsWith("[L") && splitArg.endsWith(";")) {
                componentStr = splitArg.substring(2, splitArg.length() - 1);
                componentCls = RenameHandler.INSTANCE.loadType(componentStr);
                argType = Array.newInstance(componentCls, 0).getClass();
            } else {
                argType = AbstractTypeStringConverter.doParse(splitArg);
            }
            types2.add(argType);
        }
        return AbstractTypeStringConverter.newParameterizedType(base, types2.toArray(new Type[types2.size()]));
    }

    private static List<String> split(String str) {
        ArrayList<String> result2 = new ArrayList<String>();
        int genericCount = 0;
        int startPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ',' && genericCount == 0) {
                result2.add(str.substring(startPos, i).trim());
                startPos = i + 1;
                continue;
            }
            if (str.charAt(i) == '<') {
                ++genericCount;
                continue;
            }
            if (str.charAt(i) != '>') continue;
            --genericCount;
        }
        result2.add(str.substring(startPos).trim());
        return result2;
    }

    private static Type wildExtendsType(Type bound2) throws Exception {
        return (Type)EXTENDS_TYPE.invoke(null, bound2);
    }

    private static Type wildSuperType(Type bound2) throws Exception {
        return (Type)SUPER_TYPE.invoke(null, bound2);
    }

    private static ParameterizedType newParameterizedType(Class<?> base, Type ... args2) throws Exception {
        return (ParameterizedType)NEW_PARAM_TYPE.invoke(null, base, args2);
    }

    static {
        try {
            Class<?> typesClass = RenameHandler.INSTANCE.loadType("com.google.common.reflect.Types");
            Method newParam = typesClass.getDeclaredMethod("newParameterizedType", Class.class, Type[].class);
            newParam.setAccessible(true);
            NEW_PARAM_TYPE = newParam;
            Method extendsType = typesClass.getDeclaredMethod("subtypeOf", Type.class);
            extendsType.setAccessible(true);
            EXTENDS_TYPE = extendsType;
            Method superType = typesClass.getDeclaredMethod("supertypeOf", Type.class);
            superType.setAccessible(true);
            SUPER_TYPE = superType;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

