/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import org.bson.json.Converter;
import org.bson.json.ExtendedJsonDoubleConverter;
import org.bson.json.StrictJsonWriter;

class RelaxedExtendedJsonDoubleConverter
implements Converter<Double> {
    private static final Converter<Double> FALLBACK_CONVERTER = new ExtendedJsonDoubleConverter();

    RelaxedExtendedJsonDoubleConverter() {
    }

    @Override
    public void convert(Double value2, StrictJsonWriter writer2) {
        if (value2.isNaN() || value2.isInfinite()) {
            FALLBACK_CONVERTER.convert(value2, writer2);
        } else {
            writer2.writeNumber(Double.toString(value2));
        }
    }
}

