/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.bson.BsonSerializationException;
import org.bson.ByteBuf;
import org.bson.io.BsonOutput;
import org.bson.types.ObjectId;

public abstract class OutputBuffer
extends OutputStream
implements BsonOutput {
    @Override
    public void write(byte[] b2) {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void close() {
    }

    @Override
    public void write(byte[] bytes2, int offset, int length2) {
        this.writeBytes(bytes2, offset, length2);
    }

    @Override
    public void writeBytes(byte[] bytes2) {
        this.writeBytes(bytes2, 0, bytes2.length);
    }

    @Override
    public void writeInt32(int value2) {
        this.write(value2 >> 0);
        this.write(value2 >> 8);
        this.write(value2 >> 16);
        this.write(value2 >> 24);
    }

    @Override
    public void writeInt32(int position2, int value2) {
        this.write(position2, value2 >> 0);
        this.write(position2 + 1, value2 >> 8);
        this.write(position2 + 2, value2 >> 16);
        this.write(position2 + 3, value2 >> 24);
    }

    @Override
    public void writeInt64(long value2) {
        this.write((byte)(0xFFL & value2 >> 0));
        this.write((byte)(0xFFL & value2 >> 8));
        this.write((byte)(0xFFL & value2 >> 16));
        this.write((byte)(0xFFL & value2 >> 24));
        this.write((byte)(0xFFL & value2 >> 32));
        this.write((byte)(0xFFL & value2 >> 40));
        this.write((byte)(0xFFL & value2 >> 48));
        this.write((byte)(0xFFL & value2 >> 56));
    }

    @Override
    public void writeDouble(double x) {
        this.writeLong(Double.doubleToRawLongBits(x));
    }

    @Override
    public void writeString(String str) {
        this.writeInt(0);
        int strLen = this.writeCharacters(str, false);
        this.writeInt32(this.getPosition() - strLen - 4, strLen);
    }

    @Override
    public void writeCString(String value2) {
        this.writeCharacters(value2, true);
    }

    @Override
    public void writeObjectId(ObjectId value2) {
        this.write(value2.toByteArray());
    }

    public int size() {
        return this.getSize();
    }

    public abstract int pipe(OutputStream var1) throws IOException;

    public abstract List<ByteBuf> getByteBuffers();

    @Override
    public abstract void truncateToPosition(int var1);

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(this.size());
            this.pipe(bout);
            return bout.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("should be impossible", ioe);
        }
    }

    @Override
    public void write(int value2) {
        this.writeByte(value2);
    }

    public void writeInt(int value2) {
        this.writeInt32(value2);
    }

    public String toString() {
        return this.getClass().getName() + " size: " + this.size() + " pos: " + this.getPosition();
    }

    protected abstract void write(int var1, int var2);

    public void writeLong(long value2) {
        this.writeInt64(value2);
    }

    private int writeCharacters(String str, boolean checkForNullCharacters) {
        int c;
        int len2 = str.length();
        int total2 = 0;
        for (int i = 0; i < len2; i += Character.charCount(c)) {
            c = Character.codePointAt(str, i);
            if (checkForNullCharacters && c == 0) {
                throw new BsonSerializationException(String.format("BSON cstring '%s' is not valid because it contains a null character at index %d", str, i));
            }
            if (c < 128) {
                this.write((byte)c);
                ++total2;
                continue;
            }
            if (c < 2048) {
                this.write((byte)(192 + (c >> 6)));
                this.write((byte)(128 + (c & 0x3F)));
                total2 += 2;
                continue;
            }
            if (c < 65536) {
                this.write((byte)(224 + (c >> 12)));
                this.write((byte)(128 + (c >> 6 & 0x3F)));
                this.write((byte)(128 + (c & 0x3F)));
                total2 += 3;
                continue;
            }
            this.write((byte)(240 + (c >> 18)));
            this.write((byte)(128 + (c >> 12 & 0x3F)));
            this.write((byte)(128 + (c >> 6 & 0x3F)));
            this.write((byte)(128 + (c & 0x3F)));
            total2 += 4;
        }
        this.write(0);
        return ++total2;
    }
}

