/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.assertions.Assertions;
import org.bson.codecs.pojo.PropertyReflectionUtils;
import org.bson.codecs.pojo.TypeWithTypeParameters;

final class TypeData<T>
implements TypeWithTypeParameters<T> {
    private final Class<T> type;
    private final List<TypeData<?>> typeParameters;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_CLASS_MAP;

    public static <T> Builder<T> builder(Class<T> type) {
        return new Builder(Assertions.notNull("type", type));
    }

    public static TypeData<?> newInstance(Method method2) {
        if (PropertyReflectionUtils.isGetter(method2)) {
            return TypeData.newInstance(method2.getGenericReturnType(), method2.getReturnType());
        }
        return TypeData.newInstance(method2.getGenericParameterTypes()[0], method2.getParameterTypes()[0]);
    }

    public static TypeData<?> newInstance(Field field2) {
        return TypeData.newInstance(field2.getGenericType(), field2.getType());
    }

    public static <T> TypeData<T> newInstance(Type genericType, Class<T> clazz2) {
        Builder<T> builder = TypeData.builder(clazz2);
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            for (Type argType : pType.getActualTypeArguments()) {
                TypeData.getNestedTypeData(builder, argType);
            }
        }
        return builder.build();
    }

    private static <T> void getNestedTypeData(Builder<T> builder, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Builder<T> paramBuilder = TypeData.builder((Class)pType.getRawType());
            for (Type argType : pType.getActualTypeArguments()) {
                TypeData.getNestedTypeData(paramBuilder, argType);
            }
            builder.addTypeParameter(paramBuilder.build());
        } else if (type instanceof TypeVariable) {
            builder.addTypeParameter(TypeData.builder(Object.class).build());
        } else if (type instanceof Class) {
            builder.addTypeParameter(TypeData.builder((Class)type).build());
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public List<TypeData<?>> getTypeParameters() {
        return this.typeParameters;
    }

    public String toString() {
        String typeParams2 = this.typeParameters.isEmpty() ? "" : ", typeParameters=[" + TypeData.nestedTypeParameters(this.typeParameters) + "]";
        return "TypeData{type=" + this.type.getSimpleName() + typeParams2 + "}";
    }

    private static String nestedTypeParameters(List<TypeData<?>> typeParameters) {
        StringBuilder builder = new StringBuilder();
        int count2 = 0;
        int last2 = typeParameters.size();
        for (TypeData<?> typeParameter : typeParameters) {
            ++count2;
            builder.append(typeParameter.getType().getSimpleName());
            if (!typeParameter.getTypeParameters().isEmpty()) {
                builder.append(String.format("<%s>", TypeData.nestedTypeParameters(typeParameter.getTypeParameters())));
            }
            if (count2 >= last2) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeData)) {
            return false;
        }
        TypeData that2 = (TypeData)o;
        if (!this.getType().equals(that2.getType())) {
            return false;
        }
        return this.getTypeParameters().equals(that2.getTypeParameters());
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        result2 = 31 * result2 + this.getTypeParameters().hashCode();
        return result2;
    }

    private TypeData(Class<T> type, List<TypeData<?>> typeParameters) {
        this.type = this.boxType(type);
        this.typeParameters = typeParameters;
    }

    boolean isAssignableFrom(Class<?> cls) {
        return this.type.isAssignableFrom(this.boxType(cls));
    }

    private <S> Class<S> boxType(Class<S> clazz2) {
        if (clazz2.isPrimitive()) {
            return PRIMITIVE_CLASS_MAP.get(clazz2);
        }
        return clazz2;
    }

    static {
        HashMap map2 = new HashMap();
        map2.put(Boolean.TYPE, Boolean.class);
        map2.put(Byte.TYPE, Byte.class);
        map2.put(Character.TYPE, Character.class);
        map2.put(Double.TYPE, Double.class);
        map2.put(Float.TYPE, Float.class);
        map2.put(Integer.TYPE, Integer.class);
        map2.put(Long.TYPE, Long.class);
        map2.put(Short.TYPE, Short.class);
        PRIMITIVE_CLASS_MAP = map2;
    }

    public static final class Builder<T> {
        private final Class<T> type;
        private final List<TypeData<?>> typeParameters = new ArrayList();

        private Builder(Class<T> type) {
            this.type = type;
        }

        public <S> Builder<T> addTypeParameter(TypeData<S> typeParameter) {
            this.typeParameters.add(Assertions.notNull("typeParameter", typeParameter));
            return this;
        }

        public Builder<T> addTypeParameters(List<TypeData<?>> typeParameters) {
            Assertions.notNull("typeParameters", typeParameters);
            for (TypeData<?> typeParameter : typeParameters) {
                this.addTypeParameter(typeParameter);
            }
            return this;
        }

        public TypeData<T> build() {
            return new TypeData(this.type, Collections.unmodifiableList(this.typeParameters));
        }
    }
}

