/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;

final class PropertyReflectionUtils {
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";

    private PropertyReflectionUtils() {
    }

    static boolean isGetter(Method method2) {
        if (method2.getParameterTypes().length > 0) {
            return false;
        }
        if (method2.getName().startsWith(GET_PREFIX) && method2.getName().length() > GET_PREFIX.length()) {
            return Character.isUpperCase(method2.getName().charAt(GET_PREFIX.length()));
        }
        if (method2.getName().startsWith(IS_PREFIX) && method2.getName().length() > IS_PREFIX.length()) {
            return Character.isUpperCase(method2.getName().charAt(IS_PREFIX.length()));
        }
        return false;
    }

    static boolean isSetter(Method method2) {
        if (method2.getName().startsWith(SET_PREFIX) && method2.getName().length() > SET_PREFIX.length() && method2.getParameterTypes().length == 1) {
            return Character.isUpperCase(method2.getName().charAt(SET_PREFIX.length()));
        }
        return false;
    }

    static String toPropertyName(Method method2) {
        String name;
        String propertyName = name.substring((name = method2.getName()).startsWith(IS_PREFIX) ? 2 : 3, name.length());
        char[] chars = propertyName.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static PropertyMethods getPropertyMethods(Class<?> clazz2) {
        ArrayList<Method> setters = new ArrayList<Method>();
        ArrayList<Method> getters = new ArrayList<Method>();
        for (Method method2 : clazz2.getDeclaredMethods()) {
            if (!Modifier.isPublic(method2.getModifiers()) || method2.isBridge()) continue;
            if (PropertyReflectionUtils.isGetter(method2)) {
                getters.add(method2);
                continue;
            }
            if (!PropertyReflectionUtils.isSetter(method2)) continue;
            setters.add(method2);
        }
        return new PropertyMethods(getters, setters);
    }

    static class PropertyMethods {
        private final Collection<Method> getterMethods;
        private final Collection<Method> setterMethods;

        PropertyMethods(Collection<Method> getterMethods, Collection<Method> setterMethods) {
            this.getterMethods = getterMethods;
            this.setterMethods = setterMethods;
        }

        Collection<Method> getGetterMethods() {
            return this.getterMethods;
        }

        Collection<Method> getSetterMethods() {
            return this.setterMethods;
        }
    }
}

