/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import org.bson.codecs.Codec;
import org.bson.codecs.pojo.PropertyAccessor;
import org.bson.codecs.pojo.PropertyModelBuilder;
import org.bson.codecs.pojo.PropertySerialization;
import org.bson.codecs.pojo.TypeData;

public final class PropertyModel<T> {
    private final String name;
    private final String readName;
    private final String writeName;
    private final TypeData<T> typeData;
    private final Codec<T> codec;
    private final PropertySerialization<T> propertySerialization;
    private final Boolean useDiscriminator;
    private final PropertyAccessor<T> propertyAccessor;
    private volatile Codec<T> cachedCodec;

    PropertyModel(String name, String readName, String writeName, TypeData<T> typeData, Codec<T> codec, PropertySerialization<T> propertySerialization, Boolean useDiscriminator, PropertyAccessor<T> propertyAccessor) {
        this.name = name;
        this.readName = readName;
        this.writeName = writeName;
        this.typeData = typeData;
        this.codec = codec;
        this.cachedCodec = codec;
        this.propertySerialization = propertySerialization;
        this.useDiscriminator = useDiscriminator;
        this.propertyAccessor = propertyAccessor;
    }

    public static <T> PropertyModelBuilder<T> builder() {
        return new PropertyModelBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getWriteName() {
        return this.writeName;
    }

    public String getReadName() {
        return this.readName;
    }

    public boolean isWritable() {
        return this.writeName != null;
    }

    public boolean isReadable() {
        return this.readName != null;
    }

    public TypeData<T> getTypeData() {
        return this.typeData;
    }

    public Codec<T> getCodec() {
        return this.codec;
    }

    public boolean shouldSerialize(T value2) {
        return this.propertySerialization.shouldSerialize(value2);
    }

    public PropertyAccessor<T> getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public Boolean useDiscriminator() {
        return this.useDiscriminator;
    }

    public String toString() {
        return "PropertyModel{propertyName='" + this.name + "', readName='" + this.readName + "', writeName='" + this.writeName + "', typeData=" + this.typeData + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyModel that2 = (PropertyModel)o;
        if (this.getName() != null ? !this.getName().equals(that2.getName()) : that2.getName() != null) {
            return false;
        }
        if (this.getReadName() != null ? !this.getReadName().equals(that2.getReadName()) : that2.getReadName() != null) {
            return false;
        }
        if (this.getWriteName() != null ? !this.getWriteName().equals(that2.getWriteName()) : that2.getWriteName() != null) {
            return false;
        }
        if (this.getTypeData() != null ? !this.getTypeData().equals(that2.getTypeData()) : that2.getTypeData() != null) {
            return false;
        }
        if (this.getCodec() != null ? !this.getCodec().equals(that2.getCodec()) : that2.getCodec() != null) {
            return false;
        }
        if (this.getPropertySerialization() != null ? !this.getPropertySerialization().equals(that2.getPropertySerialization()) : that2.getPropertySerialization() != null) {
            return false;
        }
        if (this.useDiscriminator != null ? !this.useDiscriminator.equals(that2.useDiscriminator) : that2.useDiscriminator != null) {
            return false;
        }
        if (this.getPropertyAccessor() != null ? !this.getPropertyAccessor().equals(that2.getPropertyAccessor()) : that2.getPropertyAccessor() != null) {
            return false;
        }
        return !(this.getCachedCodec() != null ? !this.getCachedCodec().equals(that2.getCachedCodec()) : that2.getCachedCodec() != null);
    }

    public int hashCode() {
        int result2 = this.getName() != null ? this.getName().hashCode() : 0;
        result2 = 31 * result2 + (this.getReadName() != null ? this.getReadName().hashCode() : 0);
        result2 = 31 * result2 + (this.getWriteName() != null ? this.getWriteName().hashCode() : 0);
        result2 = 31 * result2 + (this.getTypeData() != null ? this.getTypeData().hashCode() : 0);
        result2 = 31 * result2 + (this.getCodec() != null ? this.getCodec().hashCode() : 0);
        result2 = 31 * result2 + (this.getPropertySerialization() != null ? this.getPropertySerialization().hashCode() : 0);
        result2 = 31 * result2 + (this.useDiscriminator != null ? this.useDiscriminator.hashCode() : 0);
        result2 = 31 * result2 + (this.getPropertyAccessor() != null ? this.getPropertyAccessor().hashCode() : 0);
        result2 = 31 * result2 + (this.getCachedCodec() != null ? this.getCachedCodec().hashCode() : 0);
        return result2;
    }

    PropertySerialization<T> getPropertySerialization() {
        return this.propertySerialization;
    }

    void cachedCodec(Codec<T> codec) {
        this.cachedCodec = codec;
    }

    Codec<T> getCachedCodec() {
        return this.cachedCodec;
    }
}

