/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.ClassModel;

final class DiscriminatorLookup {
    private final Map<String, Class<?>> discriminatorClassMap = new ConcurrentHashMap();
    private final Set<String> packages;

    DiscriminatorLookup(Map<Class<?>, ClassModel<?>> classModels, Set<String> packages2) {
        for (ClassModel<?> classModel : classModels.values()) {
            if (classModel.getDiscriminator() == null) continue;
            this.discriminatorClassMap.put(classModel.getDiscriminator(), classModel.getType());
        }
        this.packages = packages2;
    }

    public Class<?> lookup(String discriminator) {
        if (this.discriminatorClassMap.containsKey(discriminator)) {
            return this.discriminatorClassMap.get(discriminator);
        }
        Class<?> clazz2 = this.getClassForName(discriminator);
        if (clazz2 == null) {
            clazz2 = this.searchPackages(discriminator);
        }
        if (clazz2 == null) {
            throw new CodecConfigurationException(String.format("A class could not be found for the discriminator: '%s'.", discriminator));
        }
        this.discriminatorClassMap.put(discriminator, clazz2);
        return clazz2;
    }

    void addClassModel(ClassModel<?> classModel) {
        if (classModel.getDiscriminator() != null) {
            this.discriminatorClassMap.put(classModel.getDiscriminator(), classModel.getType());
        }
    }

    private Class<?> getClassForName(String discriminator) {
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(discriminator);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz2;
    }

    private Class<?> searchPackages(String discriminator) {
        Class<?> clazz2 = null;
        for (String packageName : this.packages) {
            clazz2 = this.getClassForName(packageName + "." + discriminator);
            if (clazz2 == null) continue;
            return clazz2;
        }
        return clazz2;
    }
}

