/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonProperty;

final class CreatorExecutable<T> {
    private final Class<T> clazz;
    private final Constructor<T> constructor;
    private final Method method;
    private final List<BsonProperty> properties = new ArrayList<BsonProperty>();
    private final Integer idPropertyIndex;
    private final List<Class<?>> parameterTypes = new ArrayList();
    private final List<Type> parameterGenericTypes = new ArrayList<Type>();

    CreatorExecutable(Class<T> clazz2, Constructor<T> constructor2) {
        this(clazz2, constructor2, null);
    }

    CreatorExecutable(Class<T> clazz2, Method method2) {
        this(clazz2, null, method2);
    }

    private CreatorExecutable(Class<T> clazz2, Constructor<T> constructor2, Method method2) {
        this.clazz = clazz2;
        this.constructor = constructor2;
        this.method = method2;
        Integer idPropertyIndex = null;
        if (constructor2 != null || method2 != null) {
            Class<?>[] paramTypes2 = constructor2 != null ? constructor2.getParameterTypes() : method2.getParameterTypes();
            Type[] genericParamTypes = constructor2 != null ? constructor2.getGenericParameterTypes() : method2.getGenericParameterTypes();
            this.parameterTypes.addAll(Arrays.asList(paramTypes2));
            this.parameterGenericTypes.addAll(Arrays.asList(genericParamTypes));
            Annotation[][] parameterAnnotations = constructor2 != null ? constructor2.getParameterAnnotations() : method2.getParameterAnnotations();
            block0: for (int i = 0; i < parameterAnnotations.length; ++i) {
                Annotation[] parameterAnnotation;
                for (Annotation annotation2 : parameterAnnotation = parameterAnnotations[i]) {
                    if (annotation2.annotationType().equals(BsonProperty.class)) {
                        this.properties.add((BsonProperty)annotation2);
                        continue block0;
                    }
                    if (!annotation2.annotationType().equals(BsonId.class)) continue;
                    this.properties.add(null);
                    idPropertyIndex = i;
                    continue block0;
                }
            }
        }
        this.idPropertyIndex = idPropertyIndex;
    }

    Class<T> getType() {
        return this.clazz;
    }

    List<BsonProperty> getProperties() {
        return this.properties;
    }

    Integer getIdPropertyIndex() {
        return this.idPropertyIndex;
    }

    List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    List<Type> getParameterGenericTypes() {
        return this.parameterGenericTypes;
    }

    T getInstance() {
        this.checkHasAnExecutable();
        try {
            if (this.constructor != null) {
                return this.constructor.newInstance(new Object[0]);
            }
            return (T)this.method.invoke(this.clazz, new Object[0]);
        }
        catch (Exception e) {
            throw new CodecConfigurationException(e.getMessage(), e);
        }
    }

    T getInstance(Object[] params2) {
        this.checkHasAnExecutable();
        try {
            if (this.constructor != null) {
                return this.constructor.newInstance(params2);
            }
            return (T)this.method.invoke(this.clazz, params2);
        }
        catch (Exception e) {
            throw new CodecConfigurationException(e.getMessage(), e);
        }
    }

    CodecConfigurationException getError(Class<?> clazz2, String msg) {
        return CreatorExecutable.getError(clazz2, this.constructor != null, msg);
    }

    private void checkHasAnExecutable() {
        if (this.constructor == null && this.method == null) {
            throw new CodecConfigurationException(String.format("Cannot find a public constructor for '%s'.", this.clazz.getSimpleName()));
        }
    }

    private static CodecConfigurationException getError(Class<?> clazz2, boolean isConstructor, String msg) {
        return new CodecConfigurationException(String.format("Invalid @BsonCreator %s in %s. %s", isConstructor ? "constructor" : "method", clazz2.getSimpleName(), msg));
    }
}

