/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.configuration;

import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.configuration.LazyCodec;
import org.bson.codecs.configuration.ProvidersCodecRegistry;

class ChildCodecRegistry<T>
implements CodecRegistry {
    private final ChildCodecRegistry<?> parent;
    private final ProvidersCodecRegistry registry;
    private final Class<T> codecClass;

    ChildCodecRegistry(ProvidersCodecRegistry registry, Class<T> codecClass) {
        this.codecClass = codecClass;
        this.parent = null;
        this.registry = registry;
    }

    private ChildCodecRegistry(ChildCodecRegistry<?> parent2, Class<T> codecClass) {
        this.parent = parent2;
        this.codecClass = codecClass;
        this.registry = parent2.registry;
    }

    public Class<T> getCodecClass() {
        return this.codecClass;
    }

    public <U> Codec<U> get(Class<U> clazz2) {
        if (this.hasCycles(clazz2).booleanValue()) {
            return new LazyCodec<U>(this.registry, clazz2);
        }
        return this.registry.get(new ChildCodecRegistry<U>(this, clazz2));
    }

    private <U> Boolean hasCycles(Class<U> theClass) {
        ChildCodecRegistry<?> current = this;
        while (current != null) {
            if (current.codecClass.equals(theClass)) {
                return true;
            }
            current = current.parent;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChildCodecRegistry that2 = (ChildCodecRegistry)o;
        if (!this.codecClass.equals(that2.codecClass)) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(that2.parent) : that2.parent != null) {
            return false;
        }
        return this.registry.equals(that2.registry);
    }

    public int hashCode() {
        int result2 = this.parent != null ? this.parent.hashCode() : 0;
        result2 = 31 * result2 + this.registry.hashCode();
        result2 = 31 * result2 + this.codecClass.hashCode();
        return result2;
    }
}

