/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.NumberCodecHelper;

public class ShortCodec
implements Codec<Short> {
    @Override
    public void encode(BsonWriter writer2, Short value2, EncoderContext encoderContext) {
        writer2.writeInt32(value2.shortValue());
    }

    @Override
    public Short decode(BsonReader reader, DecoderContext decoderContext) {
        int value2 = NumberCodecHelper.decodeInt(reader);
        if (value2 < Short.MIN_VALUE || value2 > Short.MAX_VALUE) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Short.", value2));
        }
        return (short)value2;
    }

    @Override
    public Class<Short> getEncoderClass() {
        return Short.class;
    }
}

