/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.Transformer;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IdGenerator;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class DocumentCodec
implements CollectibleCodec<Document> {
    private static final String ID_FIELD_NAME = "_id";
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider()));
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap();
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private final IdGenerator idGenerator;
    private final Transformer valueTransformer;

    public DocumentCodec() {
        this(DEFAULT_REGISTRY);
    }

    public DocumentCodec(CodecRegistry registry) {
        this(registry, DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public DocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap) {
        this(registry, bsonTypeClassMap, null);
    }

    public DocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry);
        this.idGenerator = new ObjectIdGenerator();
        this.valueTransformer = valueTransformer != null ? valueTransformer : new Transformer(){

            @Override
            public Object transform(Object value2) {
                return value2;
            }
        };
    }

    @Override
    public boolean documentHasId(Document document2) {
        return document2.containsKey(ID_FIELD_NAME);
    }

    @Override
    public BsonValue getDocumentId(Document document2) {
        if (!this.documentHasId(document2)) {
            throw new IllegalStateException("The document does not contain an _id");
        }
        Object id2 = document2.get(ID_FIELD_NAME);
        if (id2 instanceof BsonValue) {
            return (BsonValue)id2;
        }
        BsonDocument idHoldingDocument = new BsonDocument();
        BsonDocumentWriter writer2 = new BsonDocumentWriter(idHoldingDocument);
        writer2.writeStartDocument();
        writer2.writeName(ID_FIELD_NAME);
        this.writeValue(writer2, EncoderContext.builder().build(), id2);
        writer2.writeEndDocument();
        return idHoldingDocument.get(ID_FIELD_NAME);
    }

    @Override
    public Document generateIdIfAbsentFromDocument(Document document2) {
        if (!this.documentHasId(document2)) {
            document2.put(ID_FIELD_NAME, this.idGenerator.generate());
        }
        return document2;
    }

    @Override
    public void encode(BsonWriter writer2, Document document2, EncoderContext encoderContext) {
        this.writeMap(writer2, document2, encoderContext);
    }

    @Override
    public Document decode(BsonReader reader, DecoderContext decoderContext) {
        Document document2 = new Document();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName2 = reader.readName();
            document2.put(fieldName2, this.readValue(reader, decoderContext));
        }
        reader.readEndDocument();
        return document2;
    }

    @Override
    public Class<Document> getEncoderClass() {
        return Document.class;
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, Map<String, Object> document2) {
        if (encoderContext.isEncodingCollectibleDocument() && document2.containsKey(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, encoderContext, document2.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String key) {
        return encoderContext.isEncodingCollectibleDocument() && key.equals(ID_FIELD_NAME);
    }

    private void writeValue(BsonWriter writer2, EncoderContext encoderContext, Object value2) {
        if (value2 == null) {
            writer2.writeNull();
        } else if (value2 instanceof Iterable) {
            this.writeIterable(writer2, (Iterable)value2, encoderContext.getChildContext());
        } else if (value2 instanceof Map) {
            this.writeMap(writer2, (Map)value2, encoderContext.getChildContext());
        } else {
            Codec<?> codec = this.registry.get(value2.getClass());
            encoderContext.encodeWithChildContext(codec, writer2, value2);
        }
    }

    private void writeMap(BsonWriter writer2, Map<String, Object> map2, EncoderContext encoderContext) {
        writer2.writeStartDocument();
        this.beforeFields(writer2, encoderContext, map2);
        for (Map.Entry<String, Object> entry2 : map2.entrySet()) {
            if (this.skipField(encoderContext, entry2.getKey())) continue;
            writer2.writeName(entry2.getKey());
            this.writeValue(writer2, encoderContext, entry2.getValue());
        }
        writer2.writeEndDocument();
    }

    private void writeIterable(BsonWriter writer2, Iterable<Object> list2, EncoderContext encoderContext) {
        writer2.writeStartArray();
        for (Object value2 : list2) {
            this.writeValue(writer2, encoderContext, value2);
        }
        writer2.writeEndArray();
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.ARRAY) {
            return this.readList(reader, decoderContext);
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid(reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return this.registry.get(UUID.class).decode(reader, decoderContext);
        }
        return this.valueTransformer.transform(this.bsonTypeCodecMap.get(bsonType).decode(reader, decoderContext));
    }

    private List<Object> readList(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<Object> list2 = new ArrayList<Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list2.add(this.readValue(reader, decoderContext));
        }
        reader.readEndArray();
        return list2;
    }
}

