/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.NumberCodecHelper;

public class ByteCodec
implements Codec<Byte> {
    @Override
    public void encode(BsonWriter writer2, Byte value2, EncoderContext encoderContext) {
        writer2.writeInt32(value2.byteValue());
    }

    @Override
    public Byte decode(BsonReader reader, DecoderContext decoderContext) {
        int value2 = NumberCodecHelper.decodeInt(reader);
        if (value2 < -128 || value2 > 127) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Byte.", value2));
        }
        return (byte)value2;
    }

    @Override
    public Class<Byte> getEncoderClass() {
        return Byte.class;
    }
}

