/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonBinaryReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.RawBsonArray;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BsonInputMark;

final class RawBsonValueHelper {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());

    static BsonValue decode(byte[] bytes2, BsonBinaryReader bsonReader) {
        if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT || bsonReader.getCurrentBsonType() == BsonType.ARRAY) {
            int position2 = bsonReader.getBsonInput().getPosition();
            BsonInputMark mark2 = bsonReader.getBsonInput().getMark(4);
            int size2 = bsonReader.getBsonInput().readInt32();
            mark2.reset();
            bsonReader.skipValue();
            if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new RawBsonDocument(bytes2, position2, size2);
            }
            return new RawBsonArray(bytes2, position2, size2);
        }
        return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType(bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
    }

    private RawBsonValueHelper() {
    }
}

