/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.assertions.Assertions;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;
import org.bson.types.ObjectId;

public class Document
implements Map<String, Object>,
Serializable,
Bson {
    private static final long serialVersionUID = 6297731997167536582L;
    private final LinkedHashMap<String, Object> documentAsMap;

    public Document() {
        this.documentAsMap = new LinkedHashMap();
    }

    public Document(String key, Object value2) {
        this.documentAsMap = new LinkedHashMap();
        this.documentAsMap.put(key, value2);
    }

    public Document(Map<String, Object> map2) {
        this.documentAsMap = new LinkedHashMap<String, Object>(map2);
    }

    public static Document parse(String json) {
        return Document.parse(json, new DocumentCodec());
    }

    public static Document parse(String json, Decoder<Document> decoder) {
        Assertions.notNull("codec", decoder);
        JsonReader bsonReader = new JsonReader(json);
        return decoder.decode(bsonReader, DecoderContext.builder().build());
    }

    public <C> BsonDocument toBsonDocument(Class<C> documentClass, CodecRegistry codecRegistry) {
        return new BsonDocumentWrapper<Document>(this, codecRegistry.get(Document.class));
    }

    public Document append(String key, Object value2) {
        this.documentAsMap.put(key, value2);
        return this;
    }

    public <T> T get(Object key, Class<T> clazz2) {
        Assertions.notNull("clazz", clazz2);
        return clazz2.cast(this.documentAsMap.get(key));
    }

    public <T> T get(Object key, T defaultValue2) {
        Assertions.notNull("defaultValue", defaultValue2);
        Object value2 = this.documentAsMap.get(key);
        return (T)(value2 == null ? defaultValue2 : value2);
    }

    public <T> T getEmbedded(List<?> keys2, Class<T> clazz2) {
        Assertions.notNull("keys", keys2);
        Assertions.isTrue("keys", !keys2.isEmpty());
        Assertions.notNull("clazz", clazz2);
        return this.getEmbeddedValue(keys2, clazz2, null);
    }

    public <T> T getEmbedded(List<?> keys2, T defaultValue2) {
        Assertions.notNull("keys", keys2);
        Assertions.isTrue("keys", !keys2.isEmpty());
        Assertions.notNull("defaultValue", defaultValue2);
        return this.getEmbeddedValue(keys2, null, defaultValue2);
    }

    private <T> T getEmbeddedValue(List<?> keys2, Class<T> clazz2, T defaultValue2) {
        Object value2 = this;
        Iterator<?> keyIterator = keys2.iterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            if ((value2 = ((Document)value2).get(key)) instanceof Document) continue;
            if (value2 == null) {
                return defaultValue2;
            }
            if (!keyIterator.hasNext()) continue;
            throw new ClassCastException(String.format("At key %s, the value is not a Document (%s)", key, value2.getClass().getName()));
        }
        return (T)(clazz2 != null ? clazz2.cast(value2) : value2);
    }

    public Integer getInteger(Object key) {
        return (Integer)this.get(key);
    }

    public int getInteger(Object key, int defaultValue2) {
        return this.get(key, defaultValue2);
    }

    public Long getLong(Object key) {
        return (Long)this.get(key);
    }

    public Double getDouble(Object key) {
        return (Double)this.get(key);
    }

    public String getString(Object key) {
        return (String)this.get(key);
    }

    public Boolean getBoolean(Object key) {
        return (Boolean)this.get(key);
    }

    public boolean getBoolean(Object key, boolean defaultValue2) {
        return this.get(key, defaultValue2);
    }

    public ObjectId getObjectId(Object key) {
        return (ObjectId)this.get(key);
    }

    public Date getDate(Object key) {
        return (Date)this.get(key);
    }

    public <T> List<T> getList(Object key, Class<T> clazz2) {
        Assertions.notNull("clazz", clazz2);
        return this.constructValuesList(key, clazz2, null);
    }

    public <T> List<T> getList(Object key, Class<T> clazz2, List<T> defaultValue2) {
        Assertions.notNull("defaultValue", defaultValue2);
        Assertions.notNull("clazz", clazz2);
        return this.constructValuesList(key, clazz2, defaultValue2);
    }

    private <T> List<T> constructValuesList(Object key, Class<T> clazz2, List<T> defaultValue2) {
        List value2 = (List)((Object)this.get(key, (T)List.class));
        if (value2 == null) {
            return defaultValue2;
        }
        for (Object item : value2) {
            if (clazz2.isAssignableFrom(item.getClass())) continue;
            throw new ClassCastException(String.format("List element cannot be cast to %s", clazz2.getName()));
        }
        return value2;
    }

    public String toJson() {
        return this.toJson(new JsonWriterSettings());
    }

    public String toJson(JsonWriterSettings writerSettings) {
        return this.toJson(writerSettings, new DocumentCodec());
    }

    public String toJson(Encoder<Document> encoder) {
        return this.toJson(new JsonWriterSettings(), encoder);
    }

    public String toJson(JsonWriterSettings writerSettings, Encoder<Document> encoder) {
        JsonWriter writer2 = new JsonWriter(new StringWriter(), writerSettings);
        encoder.encode(writer2, this, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
        return writer2.getWriter().toString();
    }

    @Override
    public int size() {
        return this.documentAsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.documentAsMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.documentAsMap.containsValue(value2);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.documentAsMap.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.documentAsMap.get(key);
    }

    @Override
    public Object put(String key, Object value2) {
        return this.documentAsMap.put(key, value2);
    }

    @Override
    public Object remove(Object key) {
        return this.documentAsMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> map2) {
        this.documentAsMap.putAll(map2);
    }

    @Override
    public void clear() {
        this.documentAsMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.documentAsMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.documentAsMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.documentAsMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document2 = (Document)o;
        return this.documentAsMap.equals(document2.documentAsMap);
    }

    @Override
    public int hashCode() {
        return this.documentAsMap.hashCode();
    }

    public String toString() {
        return "Document{" + this.documentAsMap + '}';
    }
}

