/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.ByteBuf;

public class ByteBufNIO
implements ByteBuf {
    private ByteBuffer buf;
    private final AtomicInteger referenceCount = new AtomicInteger(1);

    public ByteBufNIO(ByteBuffer buf) {
        this.buf = buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    @Override
    public ByteBufNIO retain() {
        if (this.referenceCount.incrementAndGet() == 1) {
            this.referenceCount.decrementAndGet();
            throw new IllegalStateException("Attempted to increment the reference count when it is already 0");
        }
        return this;
    }

    @Override
    public void release() {
        if (this.referenceCount.decrementAndGet() < 0) {
            this.referenceCount.incrementAndGet();
            throw new IllegalStateException("Attempted to decrement the reference count below 0");
        }
        if (this.referenceCount.get() == 0) {
            this.buf = null;
        }
    }

    @Override
    public int capacity() {
        return this.buf.capacity();
    }

    @Override
    public ByteBuf put(int index2, byte b2) {
        this.buf.put(index2, b2);
        return this;
    }

    @Override
    public int remaining() {
        return this.buf.remaining();
    }

    @Override
    public ByteBuf put(byte[] src, int offset, int length2) {
        this.buf.put(src, offset, length2);
        return this;
    }

    @Override
    public boolean hasRemaining() {
        return this.buf.hasRemaining();
    }

    @Override
    public ByteBuf put(byte b2) {
        this.buf.put(b2);
        return this;
    }

    @Override
    public ByteBuf flip() {
        ((Buffer)this.buf).flip();
        return this;
    }

    @Override
    public byte[] array() {
        return this.buf.array();
    }

    @Override
    public int limit() {
        return this.buf.limit();
    }

    @Override
    public ByteBuf position(int newPosition) {
        ((Buffer)this.buf).position(newPosition);
        return this;
    }

    @Override
    public ByteBuf clear() {
        ((Buffer)this.buf).clear();
        return this;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
        return this;
    }

    @Override
    public byte get() {
        return this.buf.get();
    }

    @Override
    public byte get(int index2) {
        return this.buf.get(index2);
    }

    @Override
    public ByteBuf get(byte[] bytes2) {
        this.buf.get(bytes2);
        return this;
    }

    @Override
    public ByteBuf get(int index2, byte[] bytes2) {
        return this.get(index2, bytes2, 0, bytes2.length);
    }

    @Override
    public ByteBuf get(byte[] bytes2, int offset, int length2) {
        this.buf.get(bytes2, offset, length2);
        return this;
    }

    @Override
    public ByteBuf get(int index2, byte[] bytes2, int offset, int length2) {
        for (int i = 0; i < length2; ++i) {
            bytes2[offset + i] = this.buf.get(index2 + i);
        }
        return this;
    }

    @Override
    public long getLong() {
        return this.buf.getLong();
    }

    @Override
    public long getLong(int index2) {
        return this.buf.getLong(index2);
    }

    @Override
    public double getDouble() {
        return this.buf.getDouble();
    }

    @Override
    public double getDouble(int index2) {
        return this.buf.getDouble(index2);
    }

    @Override
    public int getInt() {
        return this.buf.getInt();
    }

    @Override
    public int getInt(int index2) {
        return this.buf.getInt(index2);
    }

    @Override
    public int position() {
        return this.buf.position();
    }

    @Override
    public ByteBuf limit(int newLimit) {
        ((Buffer)this.buf).limit(newLimit);
        return this;
    }

    @Override
    public ByteBuf asReadOnly() {
        return new ByteBufNIO(this.buf.asReadOnlyBuffer());
    }

    @Override
    public ByteBuf duplicate() {
        return new ByteBufNIO(this.buf.duplicate());
    }

    @Override
    public ByteBuffer asNIO() {
        return this.buf;
    }
}

