/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Arrays;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.assertions.Assertions;

public final class BsonRegularExpression
extends BsonValue {
    private final String pattern;
    private final String options;

    public BsonRegularExpression(String pattern, String options2) {
        this.pattern = Assertions.notNull("pattern", pattern);
        this.options = options2 == null ? "" : this.sortOptionCharacters(options2);
    }

    public BsonRegularExpression(String pattern) {
        this(pattern, null);
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.REGULAR_EXPRESSION;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BsonRegularExpression that2 = (BsonRegularExpression)o;
        if (!this.options.equals(that2.options)) {
            return false;
        }
        return this.pattern.equals(that2.pattern);
    }

    public int hashCode() {
        int result2 = this.pattern.hashCode();
        result2 = 31 * result2 + this.options.hashCode();
        return result2;
    }

    public String toString() {
        return "BsonRegularExpression{pattern='" + this.pattern + '\'' + ", options='" + this.options + '\'' + '}';
    }

    private String sortOptionCharacters(String options2) {
        char[] chars = options2.toCharArray();
        Arrays.sort(chars);
        return new String(chars);
    }
}

