/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;

public class BsonJavaScriptWithScope
extends BsonValue {
    private final String code;
    private final BsonDocument scope;

    public BsonJavaScriptWithScope(String code2, BsonDocument scope2) {
        if (code2 == null) {
            throw new IllegalArgumentException("code can not be null");
        }
        if (scope2 == null) {
            throw new IllegalArgumentException("scope can not be null");
        }
        this.code = code2;
        this.scope = scope2;
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.JAVASCRIPT_WITH_SCOPE;
    }

    public String getCode() {
        return this.code;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BsonJavaScriptWithScope that2 = (BsonJavaScriptWithScope)o;
        if (!this.code.equals(that2.code)) {
            return false;
        }
        return this.scope.equals(that2.scope);
    }

    public int hashCode() {
        int result2 = this.code.hashCode();
        result2 = 31 * result2 + this.scope.hashCode();
        return result2;
    }

    public String toString() {
        return "BsonJavaScriptWithScope{code=" + this.getCode() + "scope=" + this.scope + '}';
    }

    static BsonJavaScriptWithScope clone(BsonJavaScriptWithScope from2) {
        return new BsonJavaScriptWithScope(from2.code, from2.scope.clone());
    }
}

