/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.AbstractBsonWriter;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonContextType;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.BsonWriterSettings;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class BsonDocumentWriter
extends AbstractBsonWriter {
    private final BsonDocument document;

    public BsonDocumentWriter(BsonDocument document2) {
        super(new BsonWriterSettings());
        this.document = document2;
        this.setContext(new Context());
    }

    public BsonDocument getDocument() {
        return this.document;
    }

    @Override
    protected void doWriteStartDocument() {
        switch (this.getState()) {
            case INITIAL: {
                this.setContext(new Context(this.document, BsonContextType.DOCUMENT, this.getContext()));
                break;
            }
            case VALUE: {
                this.setContext(new Context(new BsonDocument(), BsonContextType.DOCUMENT, this.getContext()));
                break;
            }
            case SCOPE_DOCUMENT: {
                this.setContext(new Context(new BsonDocument(), BsonContextType.SCOPE_DOCUMENT, this.getContext()));
                break;
            }
            default: {
                throw new BsonInvalidOperationException("Unexpected state " + (Object)((Object)this.getState()));
            }
        }
    }

    @Override
    protected void doWriteEndDocument() {
        BsonValue value2 = this.getContext().container;
        this.setContext(this.getContext().getParentContext());
        if (this.getContext().getContextType() == BsonContextType.JAVASCRIPT_WITH_SCOPE) {
            BsonDocument scope2 = (BsonDocument)value2;
            BsonString code2 = (BsonString)this.getContext().container;
            this.setContext(this.getContext().getParentContext());
            this.write(new BsonJavaScriptWithScope(code2.getValue(), scope2));
        } else if (this.getContext().getContextType() != BsonContextType.TOP_LEVEL) {
            this.write(value2);
        }
    }

    @Override
    protected void doWriteStartArray() {
        this.setContext(new Context(new BsonArray(), BsonContextType.ARRAY, this.getContext()));
    }

    @Override
    protected void doWriteEndArray() {
        BsonValue array2 = this.getContext().container;
        this.setContext(this.getContext().getParentContext());
        this.write(array2);
    }

    @Override
    protected void doWriteBinaryData(BsonBinary value2) {
        this.write(value2);
    }

    @Override
    public void doWriteBoolean(boolean value2) {
        this.write(BsonBoolean.valueOf(value2));
    }

    @Override
    protected void doWriteDateTime(long value2) {
        this.write(new BsonDateTime(value2));
    }

    @Override
    protected void doWriteDBPointer(BsonDbPointer value2) {
        this.write(value2);
    }

    @Override
    protected void doWriteDouble(double value2) {
        this.write(new BsonDouble(value2));
    }

    @Override
    protected void doWriteInt32(int value2) {
        this.write(new BsonInt32(value2));
    }

    @Override
    protected void doWriteInt64(long value2) {
        this.write(new BsonInt64(value2));
    }

    @Override
    protected void doWriteDecimal128(Decimal128 value2) {
        this.write(new BsonDecimal128(value2));
    }

    @Override
    protected void doWriteJavaScript(String value2) {
        this.write(new BsonJavaScript(value2));
    }

    @Override
    protected void doWriteJavaScriptWithScope(String value2) {
        this.setContext(new Context(new BsonString(value2), BsonContextType.JAVASCRIPT_WITH_SCOPE, this.getContext()));
    }

    @Override
    protected void doWriteMaxKey() {
        this.write(new BsonMaxKey());
    }

    @Override
    protected void doWriteMinKey() {
        this.write(new BsonMinKey());
    }

    @Override
    public void doWriteNull() {
        this.write(BsonNull.VALUE);
    }

    @Override
    public void doWriteObjectId(ObjectId value2) {
        this.write(new BsonObjectId(value2));
    }

    @Override
    public void doWriteRegularExpression(BsonRegularExpression value2) {
        this.write(value2);
    }

    @Override
    public void doWriteString(String value2) {
        this.write(new BsonString(value2));
    }

    @Override
    public void doWriteSymbol(String value2) {
        this.write(new BsonSymbol(value2));
    }

    @Override
    public void doWriteTimestamp(BsonTimestamp value2) {
        this.write(value2);
    }

    @Override
    public void doWriteUndefined() {
        this.write(new BsonUndefined());
    }

    @Override
    public void flush() {
    }

    @Override
    protected Context getContext() {
        return (Context)super.getContext();
    }

    private void write(BsonValue value2) {
        this.getContext().add(value2);
    }

    private class Context
    extends AbstractBsonWriter.Context {
        private BsonValue container;

        Context(BsonValue container, BsonContextType contextType, Context parent2) {
            super(parent2, contextType);
            this.container = container;
        }

        Context() {
            super(null, BsonContextType.TOP_LEVEL);
        }

        void add(BsonValue value2) {
            if (this.container instanceof BsonArray) {
                ((BsonArray)this.container).add(value2);
            } else {
                ((BsonDocument)this.container).put(BsonDocumentWriter.this.getName(), value2);
            }
        }
    }
}

